/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.ReaderInput;
import foundation.rpg.parser.StateBase;
import foundation.rpg.parser.SyntaxError;
import foundation.rpg.parser.TokenInput;
import foundation.rpg.parser.TokenInputParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public class StreamParser<R, S extends StateBase<R>> {
    private final TokenInputParser<R, S> parser;
    private final Lexer<S> lexer;

    public StreamParser(S initialState, Lexer<S> lexer) {
        this.parser = new TokenInputParser(initialState);
        this.lexer = lexer;
    }

    public R parse(TokenInput<S> input) throws SyntaxError, IOException {
        return this.parser.parse(input);
    }

    public R parse(String name, Reader reader) throws IOException, SyntaxError {
        return this.parse(this.input(name, reader, this.lexer));
    }

    public R parseFile(String fileName) throws IOException, SyntaxError {
        return this.parse(fileName, new FileReader(fileName));
    }

    public R parseString(String content) throws IOException, SyntaxError {
        return this.parse("string", new StringReader(content));
    }

    public R parse(String name, InputStream stream) throws IOException, SyntaxError {
        return this.parse(name, new InputStreamReader(stream));
    }

    public R parseUrl(URL resource) throws IOException, SyntaxError {
        return this.parse(resource.toString(), resource.openStream());
    }

    public TokenInput<S> input(String name, Reader reader, Lexer<S> lexer) throws IOException {
        return TokenInput.tokenInput(new ReaderInput(name, reader), lexer);
    }
}

