/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Input;
import foundation.rpg.parser.ParseException;
import foundation.rpg.parser.Position;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class ReaderInput
implements Input {
    private final Reader reader;
    private int lookahead;
    private final Position position;

    public ReaderInput(String fileName, Reader reader) throws IOException {
        this.reader = reader;
        this.position = new Position(fileName);
        this.move();
    }

    public ReaderInput(String fileName) throws IOException {
        this(fileName, new FileReader(fileName));
    }

    @Override
    public int lookahead() {
        return this.lookahead;
    }

    @Override
    public Input move() throws IOException {
        this.lookahead = this.reader.read();
        this.position.move((char)this.lookahead);
        return this;
    }

    @Override
    public Position position() {
        return this.position.copy();
    }

    @Override
    public void error(String message) {
        throw new ParseException(this.position(), message);
    }
}

