/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

public class Position {
    private final String fileName;
    private int line = 1;
    private int character = 0;
    private int total = 0;

    private Position(String fileName, int line, int character, int total) {
        this.fileName = fileName;
        this.line = line;
        this.character = character;
        this.total = total;
    }

    public Position(String fileName) {
        this(fileName, 1, 0, 0);
    }

    public void move(char character) {
        ++this.total;
        if (character == '\n') {
            ++this.line;
            this.character = 0;
        } else {
            ++this.character;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public int getCharacter() {
        return this.character;
    }

    public int getTotal() {
        return this.total;
    }

    public String toString() {
        return this.fileName + ": line: " + this.line + ", character: " + this.character;
    }

    public Position copy() {
        return new Position(this.fileName, this.line, this.character, this.total);
    }
}

