/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.parser;

import foundation.rpg.parser.Input;
import foundation.rpg.parser.ParseErrorException;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.Token;
import java.io.IOException;

public class KeywordLexerBase<S> {
    private final LiteralFactory<S> literalFactory;

    public KeywordLexerBase(LiteralFactory<S> literalFactory) {
        this.literalFactory = literalFactory;
    }

    public Token<S> kwOrId(Position mark, Input input, Token<S> token) throws IOException {
        String s = token.toString();
        for (int i = input.position().getTotal() - mark.getTotal(); i < s.length(); ++i) {
            if (input.lookahead() != s.charAt(i)) {
                return this.id(mark, s.substring(0, i), input);
            }
            input.move();
        }
        if (Character.isJavaIdentifierPart(input.lookahead())) {
            return this.id(mark, s, input);
        }
        return token;
    }

    public Token<S> id(Position mark, String prefix, Input input) throws IOException {
        StringBuilder b = new StringBuilder(prefix);
        while (Character.isJavaIdentifierPart(input.lookahead())) {
            b.append((char)input.lookahead());
            input.move();
        }
        return this.literalFactory.newIdentifier(mark, b.toString());
    }

    public Token<S> string(Position mark, Input input) throws IOException {
        StringBuilder b = new StringBuilder();
        while (true) {
            switch (input.lookahead()) {
                case 34: {
                    input.move();
                    return this.literalFactory.newString(mark, b.toString());
                }
                case -1: {
                    throw new IOException("Unexpected end of input. Expected: <\">");
                }
                case 92: {
                    input.move();
                }
            }
            b.append((char)input.lookahead());
            input.move();
        }
    }

    public Token<S> groups(Position mark, char lookahead, Input input) throws IOException, ParseErrorException {
        if (Character.isDigit(lookahead)) {
            StringBuilder b = new StringBuilder().append(lookahead);
            while (Character.isDigit(input.lookahead())) {
                b.append(lookahead);
                input.move();
            }
            switch (input.lookahead()) {
                case 46: 
                case 69: 
                case 101: {
                    b.append(input.lookahead());
                    while (Character.isDigit(input.move().lookahead())) {
                        b.append(lookahead);
                    }
                    return this.literalFactory.newDouble(mark, b.toString());
                }
            }
            return this.literalFactory.newInteger(mark, b.toString());
        }
        if (Character.isJavaIdentifierStart(lookahead)) {
            return this.id(mark, "" + lookahead, input);
        }
        if (Character.isWhitespace(lookahead)) {
            StringBuilder b = new StringBuilder().append(lookahead);
            while (Character.isWhitespace(input.lookahead())) {
                b.append(input.lookahead());
                input.move();
            }
            return this.literalFactory.newWhitespace(mark, b.toString());
        }
        throw new ParseErrorException(input.position(), "Illegal input character: " + lookahead);
    }

    public static interface LiteralFactory<S> {
        public Token<S> newIdentifier(Position var1, String var2);

        public Token<S> newString(Position var1, String var2);

        public Token<S> newDouble(Position var1, String var2);

        public Token<S> newInteger(Position var1, String var2);

        public Token<S> newWhitespace(Position var1, String var2);
    }
}

