/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.sample.language.ast;

/*

N = [Start, Program, List1ListOfStatement, Statement, Expression, RelationalExpression, AdditiveExpression, MultiplicativeExpression, AtomicExpression, List3ListOfExpression, List2ListOfExpression]
T = [End, Dot, Gt, Plus, Times, Identifier, LPar, RPar, Comma]
S = Start
R = {
	Start -> Program,End
	Program -> List1ListOfStatement
	List1ListOfStatement -> 
	List1ListOfStatement -> List1ListOfStatement,Statement
	Statement -> Expression,Dot
	Expression -> RelationalExpression
	RelationalExpression -> RelationalExpression,Gt,AdditiveExpression
	AdditiveExpression -> AdditiveExpression,Plus,MultiplicativeExpression
	MultiplicativeExpression -> MultiplicativeExpression,Times,AtomicExpression
	AtomicExpression -> Identifier
	AtomicExpression -> LPar,Expression,RPar
	AtomicExpression -> Identifier,LPar,List3ListOfExpression,RPar
	List3ListOfExpression -> 
	List3ListOfExpression -> List2ListOfExpression
	List2ListOfExpression -> Expression
	List2ListOfExpression -> List2ListOfExpression,Comma,Expression
	RelationalExpression -> AdditiveExpression
	AdditiveExpression -> MultiplicativeExpression
	MultiplicativeExpression -> AtomicExpression
}

1: {
	Start -> • Program End []
	Program -> • List1ListOfStatement [End]
	List1ListOfStatement -> • [End, Identifier, LPar]
	List1ListOfStatement -> • List1ListOfStatement Statement [End, Identifier, LPar]
}
Program1: {
	Start -> Program • End []
}
List1ListOfStatement1: {
	Program -> List1ListOfStatement • [End]
	List1ListOfStatement -> List1ListOfStatement • Statement [End, Identifier, LPar]
	Statement -> • Expression Dot [End, Identifier, LPar]
	Expression -> • RelationalExpression [Dot]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [Dot, Gt]
	RelationalExpression -> • AdditiveExpression [Dot, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [Dot, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [Dot, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [Dot, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier [Dot, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [Dot, Gt, Plus, Times]
}
End1: {
	Start -> Program End • []
}
Statement1: {
	List1ListOfStatement -> List1ListOfStatement Statement • [End, Identifier, LPar]
}
Expression1: {
	Statement -> Expression • Dot [End, Identifier, LPar]
}
RelationalExpression1: {
	Expression -> RelationalExpression • [Dot]
	RelationalExpression -> RelationalExpression • Gt AdditiveExpression [Dot, Gt]
}
AdditiveExpression1: {
	RelationalExpression -> AdditiveExpression • [Dot, Gt]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [Dot, Gt, Plus]
}
MultiplicativeExpression1: {
	AdditiveExpression -> MultiplicativeExpression • [Dot, Gt, Plus]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [Dot, Gt, Plus, Times]
}
AtomicExpression1: {
	MultiplicativeExpression -> AtomicExpression • [Dot, Gt, Plus, Times]
}
Identifier1: {
	AtomicExpression -> Identifier • [Dot, Gt, Plus, Times]
	AtomicExpression -> Identifier • LPar List3ListOfExpression RPar [Dot, Gt, Plus, Times]
}
LPar1: {
	AtomicExpression -> LPar • Expression RPar [Dot, Gt, Plus, Times]
	Expression -> • RelationalExpression [RPar]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt]
	RelationalExpression -> • AdditiveExpression [RPar, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
Dot1: {
	Statement -> Expression Dot • [End, Identifier, LPar]
}
Gt1: {
	RelationalExpression -> RelationalExpression Gt • AdditiveExpression [Dot, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [Dot, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [Dot, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [Dot, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier [Dot, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [Dot, Gt, Plus, Times]
}
Plus1: {
	AdditiveExpression -> AdditiveExpression Plus • MultiplicativeExpression [Dot, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [Dot, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier [Dot, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [Dot, Gt, Plus, Times]
}
Times1: {
	MultiplicativeExpression -> MultiplicativeExpression Times • AtomicExpression [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier [Dot, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [Dot, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [Dot, Gt, Plus, Times]
}
LPar2: {
	AtomicExpression -> Identifier LPar • List3ListOfExpression RPar [Dot, Gt, Plus, Times]
	List3ListOfExpression -> • [RPar]
	List3ListOfExpression -> • List2ListOfExpression [RPar]
	List2ListOfExpression -> • Expression [RPar, Comma]
	List2ListOfExpression -> • List2ListOfExpression Comma Expression [RPar, Comma]
	Expression -> • RelationalExpression [RPar, Comma]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt, Comma]
	RelationalExpression -> • AdditiveExpression [RPar, Gt, Comma]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus, Comma]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times, Comma]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
}
Expression2: {
	AtomicExpression -> LPar Expression • RPar [Dot, Gt, Plus, Times]
}
RelationalExpression2: {
	Expression -> RelationalExpression • [RPar]
	RelationalExpression -> RelationalExpression • Gt AdditiveExpression [RPar, Gt]
}
AdditiveExpression2: {
	RelationalExpression -> AdditiveExpression • [RPar, Gt]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [RPar, Gt, Plus]
}
MultiplicativeExpression2: {
	AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [RPar, Gt, Plus, Times]
}
AtomicExpression2: {
	MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times]
}
Identifier2: {
	AtomicExpression -> Identifier • [RPar, Gt, Plus, Times]
	AtomicExpression -> Identifier • LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
LPar3: {
	AtomicExpression -> LPar • Expression RPar [RPar, Gt, Plus, Times]
	Expression -> • RelationalExpression [RPar]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt]
	RelationalExpression -> • AdditiveExpression [RPar, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
AdditiveExpression3: {
	RelationalExpression -> RelationalExpression Gt AdditiveExpression • [Dot, Gt]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [Dot, Gt, Plus]
}
MultiplicativeExpression4: {
	AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [Dot, Gt, Plus]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [Dot, Gt, Plus, Times]
}
AtomicExpression5: {
	MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [Dot, Gt, Plus, Times]
}
List3ListOfExpression1: {
	AtomicExpression -> Identifier LPar List3ListOfExpression • RPar [Dot, Gt, Plus, Times]
}
List2ListOfExpression1: {
	List3ListOfExpression -> List2ListOfExpression • [RPar]
	List2ListOfExpression -> List2ListOfExpression • Comma Expression [RPar, Comma]
}
Expression3: {
	List2ListOfExpression -> Expression • [RPar, Comma]
}
RelationalExpression3: {
	Expression -> RelationalExpression • [RPar, Comma]
	RelationalExpression -> RelationalExpression • Gt AdditiveExpression [RPar, Gt, Comma]
}
AdditiveExpression4: {
	RelationalExpression -> AdditiveExpression • [RPar, Gt, Comma]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [RPar, Gt, Plus, Comma]
}
MultiplicativeExpression5: {
	AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [RPar, Gt, Plus, Times, Comma]
}
AtomicExpression6: {
	MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
}
Identifier6: {
	AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> Identifier • LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
}
LPar7: {
	AtomicExpression -> LPar • Expression RPar [RPar, Gt, Plus, Times, Comma]
	Expression -> • RelationalExpression [RPar]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt]
	RelationalExpression -> • AdditiveExpression [RPar, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
RPar1: {
	AtomicExpression -> LPar Expression RPar • [Dot, Gt, Plus, Times]
}
Gt2: {
	RelationalExpression -> RelationalExpression Gt • AdditiveExpression [RPar, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
Plus2: {
	AdditiveExpression -> AdditiveExpression Plus • MultiplicativeExpression [RPar, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
Times2: {
	MultiplicativeExpression -> MultiplicativeExpression Times • AtomicExpression [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times]
}
LPar8: {
	AtomicExpression -> Identifier LPar • List3ListOfExpression RPar [RPar, Gt, Plus, Times]
	List3ListOfExpression -> • [RPar]
	List3ListOfExpression -> • List2ListOfExpression [RPar]
	List2ListOfExpression -> • Expression [RPar, Comma]
	List2ListOfExpression -> • List2ListOfExpression Comma Expression [RPar, Comma]
	Expression -> • RelationalExpression [RPar, Comma]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt, Comma]
	RelationalExpression -> • AdditiveExpression [RPar, Gt, Comma]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus, Comma]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times, Comma]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
}
Expression4: {
	AtomicExpression -> LPar Expression • RPar [RPar, Gt, Plus, Times]
}
RPar2: {
	AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [Dot, Gt, Plus, Times]
}
Comma1: {
	List2ListOfExpression -> List2ListOfExpression Comma • Expression [RPar, Comma]
	Expression -> • RelationalExpression [RPar, Comma]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Comma, Gt]
	RelationalExpression -> • AdditiveExpression [RPar, Comma, Gt]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Comma, Gt, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Comma, Gt, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Comma, Gt, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Comma, Gt, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Comma, Gt, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Comma, Gt, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Comma, Gt, Plus, Times]
}
Gt3: {
	RelationalExpression -> RelationalExpression Gt • AdditiveExpression [RPar, Gt, Comma]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Comma, Plus]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Comma, Plus]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Comma, Plus, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Comma, Plus, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Comma, Plus, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Comma, Plus, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Comma, Plus, Times]
}
Plus4: {
	AdditiveExpression -> AdditiveExpression Plus • MultiplicativeExpression [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Comma, Times]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Comma, Times]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Comma, Times]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Comma, Times]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Comma, Times]
}
Times4: {
	MultiplicativeExpression -> MultiplicativeExpression Times • AtomicExpression [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
}
LPar10: {
	AtomicExpression -> Identifier LPar • List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
	List3ListOfExpression -> • [RPar]
	List3ListOfExpression -> • List2ListOfExpression [RPar]
	List2ListOfExpression -> • Expression [RPar, Comma]
	List2ListOfExpression -> • List2ListOfExpression Comma Expression [RPar, Comma]
	Expression -> • RelationalExpression [RPar, Comma]
	RelationalExpression -> • RelationalExpression Gt AdditiveExpression [RPar, Gt, Comma]
	RelationalExpression -> • AdditiveExpression [RPar, Gt, Comma]
	AdditiveExpression -> • AdditiveExpression Plus MultiplicativeExpression [RPar, Gt, Plus, Comma]
	AdditiveExpression -> • MultiplicativeExpression [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> • MultiplicativeExpression Times AtomicExpression [RPar, Gt, Plus, Times, Comma]
	MultiplicativeExpression -> • AtomicExpression [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • LPar Expression RPar [RPar, Gt, Plus, Times, Comma]
	AtomicExpression -> • Identifier LPar List3ListOfExpression RPar [RPar, Gt, Plus, Times, Comma]
}
Expression5: {
	AtomicExpression -> LPar Expression • RPar [RPar, Gt, Plus, Times, Comma]
}
AdditiveExpression7: {
	RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [RPar, Gt, Plus]
}
MultiplicativeExpression9: {
	AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [RPar, Gt, Plus, Times]
}
AtomicExpression11: {
	MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times]
}
List3ListOfExpression2: {
	AtomicExpression -> Identifier LPar List3ListOfExpression • RPar [RPar, Gt, Plus, Times]
}
RPar3: {
	AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times]
}
Expression7: {
	List2ListOfExpression -> List2ListOfExpression Comma Expression • [RPar, Comma]
}
AdditiveExpression10: {
	RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt, Comma]
	AdditiveExpression -> AdditiveExpression • Plus MultiplicativeExpression [RPar, Gt, Comma, Plus]
}
MultiplicativeExpression13: {
	AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus, Comma]
	MultiplicativeExpression -> MultiplicativeExpression • Times AtomicExpression [RPar, Gt, Plus, Comma, Times]
}
AtomicExpression16: {
	MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
}
List3ListOfExpression3: {
	AtomicExpression -> Identifier LPar List3ListOfExpression • RPar [RPar, Gt, Plus, Times, Comma]
}
RPar4: {
	AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
}
RPar5: {
	AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times]
}
RPar6: {
	AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]
}

1: End -> REDUCE: List1ListOfStatement -> • [End, Identifier, LPar]
1: Identifier -> REDUCE: List1ListOfStatement -> • [End, Identifier, LPar]
1: LPar -> REDUCE: List1ListOfStatement -> • [End, Identifier, LPar]
1: Program -> GOTO: Program1
1: List1ListOfStatement -> GOTO: List1ListOfStatement1
Program1: End -> GOTO: End1
List1ListOfStatement1: End -> REDUCE: Program -> List1ListOfStatement • [End]
List1ListOfStatement1: Statement -> GOTO: Statement1
List1ListOfStatement1: Expression -> GOTO: Expression1
List1ListOfStatement1: RelationalExpression -> GOTO: RelationalExpression1
List1ListOfStatement1: AdditiveExpression -> GOTO: AdditiveExpression1
List1ListOfStatement1: MultiplicativeExpression -> GOTO: MultiplicativeExpression1
List1ListOfStatement1: AtomicExpression -> GOTO: AtomicExpression1
List1ListOfStatement1: Identifier -> GOTO: Identifier1
List1ListOfStatement1: LPar -> GOTO: LPar1
End1:  -> ACCEPT: Start -> Program End • []
Statement1: End -> REDUCE: List1ListOfStatement -> List1ListOfStatement Statement • [End, Identifier, LPar]
Statement1: Identifier -> REDUCE: List1ListOfStatement -> List1ListOfStatement Statement • [End, Identifier, LPar]
Statement1: LPar -> REDUCE: List1ListOfStatement -> List1ListOfStatement Statement • [End, Identifier, LPar]
Expression1: Dot -> GOTO: Dot1
RelationalExpression1: Dot -> REDUCE: Expression -> RelationalExpression • [Dot]
RelationalExpression1: Gt -> GOTO: Gt1
AdditiveExpression1: Dot -> REDUCE: RelationalExpression -> AdditiveExpression • [Dot, Gt]
AdditiveExpression1: Gt -> REDUCE: RelationalExpression -> AdditiveExpression • [Dot, Gt]
AdditiveExpression1: Plus -> GOTO: Plus1
MultiplicativeExpression1: Dot -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression1: Gt -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression1: Plus -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression1: Times -> GOTO: Times1
AtomicExpression1: Dot -> REDUCE: MultiplicativeExpression -> AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression1: Gt -> REDUCE: MultiplicativeExpression -> AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression1: Plus -> REDUCE: MultiplicativeExpression -> AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression1: Times -> REDUCE: MultiplicativeExpression -> AtomicExpression • [Dot, Gt, Plus, Times]
Identifier1: Dot -> REDUCE: AtomicExpression -> Identifier • [Dot, Gt, Plus, Times]
Identifier1: Gt -> REDUCE: AtomicExpression -> Identifier • [Dot, Gt, Plus, Times]
Identifier1: Plus -> REDUCE: AtomicExpression -> Identifier • [Dot, Gt, Plus, Times]
Identifier1: Times -> REDUCE: AtomicExpression -> Identifier • [Dot, Gt, Plus, Times]
Identifier1: LPar -> GOTO: LPar2
LPar1: Expression -> GOTO: Expression2
LPar1: RelationalExpression -> GOTO: RelationalExpression2
LPar1: AdditiveExpression -> GOTO: AdditiveExpression2
LPar1: MultiplicativeExpression -> GOTO: MultiplicativeExpression2
LPar1: AtomicExpression -> GOTO: AtomicExpression2
LPar1: Identifier -> GOTO: Identifier2
LPar1: LPar -> GOTO: LPar3
Dot1: End -> REDUCE: Statement -> Expression Dot • [End, Identifier, LPar]
Dot1: Identifier -> REDUCE: Statement -> Expression Dot • [End, Identifier, LPar]
Dot1: LPar -> REDUCE: Statement -> Expression Dot • [End, Identifier, LPar]
Gt1: AdditiveExpression -> GOTO: AdditiveExpression3
Gt1: MultiplicativeExpression -> GOTO: MultiplicativeExpression1
Gt1: AtomicExpression -> GOTO: AtomicExpression1
Gt1: Identifier -> GOTO: Identifier1
Gt1: LPar -> GOTO: LPar1
Plus1: MultiplicativeExpression -> GOTO: MultiplicativeExpression4
Plus1: AtomicExpression -> GOTO: AtomicExpression1
Plus1: Identifier -> GOTO: Identifier1
Plus1: LPar -> GOTO: LPar1
Times1: AtomicExpression -> GOTO: AtomicExpression5
Times1: Identifier -> GOTO: Identifier1
Times1: LPar -> GOTO: LPar1
LPar2: RPar -> REDUCE: List3ListOfExpression -> • [RPar]
LPar2: List3ListOfExpression -> GOTO: List3ListOfExpression1
LPar2: List2ListOfExpression -> GOTO: List2ListOfExpression1
LPar2: Expression -> GOTO: Expression3
LPar2: RelationalExpression -> GOTO: RelationalExpression3
LPar2: AdditiveExpression -> GOTO: AdditiveExpression4
LPar2: MultiplicativeExpression -> GOTO: MultiplicativeExpression5
LPar2: AtomicExpression -> GOTO: AtomicExpression6
LPar2: Identifier -> GOTO: Identifier6
LPar2: LPar -> GOTO: LPar7
Expression2: RPar -> GOTO: RPar1
RelationalExpression2: RPar -> REDUCE: Expression -> RelationalExpression • [RPar]
RelationalExpression2: Gt -> GOTO: Gt2
AdditiveExpression2: RPar -> REDUCE: RelationalExpression -> AdditiveExpression • [RPar, Gt]
AdditiveExpression2: Gt -> REDUCE: RelationalExpression -> AdditiveExpression • [RPar, Gt]
AdditiveExpression2: Plus -> GOTO: Plus2
MultiplicativeExpression2: RPar -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression2: Gt -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression2: Plus -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression2: Times -> GOTO: Times2
AtomicExpression2: RPar -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression2: Gt -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression2: Plus -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression2: Times -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times]
Identifier2: RPar -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times]
Identifier2: Gt -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times]
Identifier2: Plus -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times]
Identifier2: Times -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times]
Identifier2: LPar -> GOTO: LPar8
LPar3: Expression -> GOTO: Expression4
LPar3: RelationalExpression -> GOTO: RelationalExpression2
LPar3: AdditiveExpression -> GOTO: AdditiveExpression2
LPar3: MultiplicativeExpression -> GOTO: MultiplicativeExpression2
LPar3: AtomicExpression -> GOTO: AtomicExpression2
LPar3: Identifier -> GOTO: Identifier2
LPar3: LPar -> GOTO: LPar3
AdditiveExpression3: Dot -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [Dot, Gt]
AdditiveExpression3: Gt -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [Dot, Gt]
AdditiveExpression3: Plus -> GOTO: Plus1
MultiplicativeExpression4: Dot -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression4: Gt -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression4: Plus -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [Dot, Gt, Plus]
MultiplicativeExpression4: Times -> GOTO: Times1
AtomicExpression5: Dot -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression5: Gt -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression5: Plus -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [Dot, Gt, Plus, Times]
AtomicExpression5: Times -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [Dot, Gt, Plus, Times]
List3ListOfExpression1: RPar -> GOTO: RPar2
List2ListOfExpression1: RPar -> REDUCE: List3ListOfExpression -> List2ListOfExpression • [RPar]
List2ListOfExpression1: Comma -> GOTO: Comma1
Expression3: RPar -> REDUCE: List2ListOfExpression -> Expression • [RPar, Comma]
Expression3: Comma -> REDUCE: List2ListOfExpression -> Expression • [RPar, Comma]
RelationalExpression3: RPar -> REDUCE: Expression -> RelationalExpression • [RPar, Comma]
RelationalExpression3: Comma -> REDUCE: Expression -> RelationalExpression • [RPar, Comma]
RelationalExpression3: Gt -> GOTO: Gt3
AdditiveExpression4: RPar -> REDUCE: RelationalExpression -> AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression4: Gt -> REDUCE: RelationalExpression -> AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression4: Comma -> REDUCE: RelationalExpression -> AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression4: Plus -> GOTO: Plus4
MultiplicativeExpression5: RPar -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression5: Gt -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression5: Plus -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression5: Comma -> REDUCE: AdditiveExpression -> MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression5: Times -> GOTO: Times4
AtomicExpression6: RPar -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression6: Gt -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression6: Plus -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression6: Times -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression6: Comma -> REDUCE: MultiplicativeExpression -> AtomicExpression • [RPar, Gt, Plus, Times, Comma]
Identifier6: RPar -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
Identifier6: Gt -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
Identifier6: Plus -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
Identifier6: Times -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
Identifier6: Comma -> REDUCE: AtomicExpression -> Identifier • [RPar, Gt, Plus, Times, Comma]
Identifier6: LPar -> GOTO: LPar10
LPar7: Expression -> GOTO: Expression5
LPar7: RelationalExpression -> GOTO: RelationalExpression2
LPar7: AdditiveExpression -> GOTO: AdditiveExpression2
LPar7: MultiplicativeExpression -> GOTO: MultiplicativeExpression2
LPar7: AtomicExpression -> GOTO: AtomicExpression2
LPar7: Identifier -> GOTO: Identifier2
LPar7: LPar -> GOTO: LPar3
RPar1: Dot -> REDUCE: AtomicExpression -> LPar Expression RPar • [Dot, Gt, Plus, Times]
RPar1: Gt -> REDUCE: AtomicExpression -> LPar Expression RPar • [Dot, Gt, Plus, Times]
RPar1: Plus -> REDUCE: AtomicExpression -> LPar Expression RPar • [Dot, Gt, Plus, Times]
RPar1: Times -> REDUCE: AtomicExpression -> LPar Expression RPar • [Dot, Gt, Plus, Times]
Gt2: AdditiveExpression -> GOTO: AdditiveExpression7
Gt2: MultiplicativeExpression -> GOTO: MultiplicativeExpression2
Gt2: AtomicExpression -> GOTO: AtomicExpression2
Gt2: Identifier -> GOTO: Identifier2
Gt2: LPar -> GOTO: LPar3
Plus2: MultiplicativeExpression -> GOTO: MultiplicativeExpression9
Plus2: AtomicExpression -> GOTO: AtomicExpression2
Plus2: Identifier -> GOTO: Identifier2
Plus2: LPar -> GOTO: LPar3
Times2: AtomicExpression -> GOTO: AtomicExpression11
Times2: Identifier -> GOTO: Identifier2
Times2: LPar -> GOTO: LPar3
LPar8: RPar -> REDUCE: List3ListOfExpression -> • [RPar]
LPar8: List3ListOfExpression -> GOTO: List3ListOfExpression2
LPar8: List2ListOfExpression -> GOTO: List2ListOfExpression1
LPar8: Expression -> GOTO: Expression3
LPar8: RelationalExpression -> GOTO: RelationalExpression3
LPar8: AdditiveExpression -> GOTO: AdditiveExpression4
LPar8: MultiplicativeExpression -> GOTO: MultiplicativeExpression5
LPar8: AtomicExpression -> GOTO: AtomicExpression6
LPar8: Identifier -> GOTO: Identifier6
LPar8: LPar -> GOTO: LPar7
Expression4: RPar -> GOTO: RPar3
RPar2: Dot -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [Dot, Gt, Plus, Times]
RPar2: Gt -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [Dot, Gt, Plus, Times]
RPar2: Plus -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [Dot, Gt, Plus, Times]
RPar2: Times -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [Dot, Gt, Plus, Times]
Comma1: Expression -> GOTO: Expression7
Comma1: RelationalExpression -> GOTO: RelationalExpression3
Comma1: AdditiveExpression -> GOTO: AdditiveExpression4
Comma1: MultiplicativeExpression -> GOTO: MultiplicativeExpression5
Comma1: AtomicExpression -> GOTO: AtomicExpression6
Comma1: Identifier -> GOTO: Identifier6
Comma1: LPar -> GOTO: LPar7
Gt3: AdditiveExpression -> GOTO: AdditiveExpression10
Gt3: MultiplicativeExpression -> GOTO: MultiplicativeExpression5
Gt3: AtomicExpression -> GOTO: AtomicExpression6
Gt3: Identifier -> GOTO: Identifier6
Gt3: LPar -> GOTO: LPar7
Plus4: MultiplicativeExpression -> GOTO: MultiplicativeExpression13
Plus4: AtomicExpression -> GOTO: AtomicExpression6
Plus4: Identifier -> GOTO: Identifier6
Plus4: LPar -> GOTO: LPar7
Times4: AtomicExpression -> GOTO: AtomicExpression16
Times4: Identifier -> GOTO: Identifier6
Times4: LPar -> GOTO: LPar7
LPar10: RPar -> REDUCE: List3ListOfExpression -> • [RPar]
LPar10: List3ListOfExpression -> GOTO: List3ListOfExpression3
LPar10: List2ListOfExpression -> GOTO: List2ListOfExpression1
LPar10: Expression -> GOTO: Expression3
LPar10: RelationalExpression -> GOTO: RelationalExpression3
LPar10: AdditiveExpression -> GOTO: AdditiveExpression4
LPar10: MultiplicativeExpression -> GOTO: MultiplicativeExpression5
LPar10: AtomicExpression -> GOTO: AtomicExpression6
LPar10: Identifier -> GOTO: Identifier6
LPar10: LPar -> GOTO: LPar7
Expression5: RPar -> GOTO: RPar4
AdditiveExpression7: RPar -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt]
AdditiveExpression7: Gt -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt]
AdditiveExpression7: Plus -> GOTO: Plus2
MultiplicativeExpression9: RPar -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression9: Gt -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression9: Plus -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus]
MultiplicativeExpression9: Times -> GOTO: Times2
AtomicExpression11: RPar -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression11: Gt -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression11: Plus -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times]
AtomicExpression11: Times -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times]
List3ListOfExpression2: RPar -> GOTO: RPar5
RPar3: RPar -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times]
RPar3: Gt -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times]
RPar3: Plus -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times]
RPar3: Times -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times]
Expression7: RPar -> REDUCE: List2ListOfExpression -> List2ListOfExpression Comma Expression • [RPar, Comma]
Expression7: Comma -> REDUCE: List2ListOfExpression -> List2ListOfExpression Comma Expression • [RPar, Comma]
AdditiveExpression10: RPar -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression10: Gt -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression10: Comma -> REDUCE: RelationalExpression -> RelationalExpression Gt AdditiveExpression • [RPar, Gt, Comma]
AdditiveExpression10: Plus -> GOTO: Plus4
MultiplicativeExpression13: RPar -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression13: Gt -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression13: Plus -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression13: Comma -> REDUCE: AdditiveExpression -> AdditiveExpression Plus MultiplicativeExpression • [RPar, Gt, Plus, Comma]
MultiplicativeExpression13: Times -> GOTO: Times4
AtomicExpression16: RPar -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression16: Gt -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression16: Plus -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression16: Times -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
AtomicExpression16: Comma -> REDUCE: MultiplicativeExpression -> MultiplicativeExpression Times AtomicExpression • [RPar, Gt, Plus, Times, Comma]
List3ListOfExpression3: RPar -> GOTO: RPar6
RPar4: RPar -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
RPar4: Gt -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
RPar4: Plus -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
RPar4: Times -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
RPar4: Comma -> REDUCE: AtomicExpression -> LPar Expression RPar • [RPar, Gt, Plus, Times, Comma]
RPar5: RPar -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times]
RPar5: Gt -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times]
RPar5: Plus -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times]
RPar5: Times -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times]
RPar6: RPar -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]
RPar6: Gt -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]
RPar6: Plus -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]
RPar6: Times -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]
RPar6: Comma -> REDUCE: AtomicExpression -> Identifier LPar List3ListOfExpression RPar • [RPar, Gt, Plus, Times, Comma]

*/

import foundation.rpg.parser.UnexpectedInputException;
import foundation.rpg.parser.StateBase;

// Generated visitor pattern based state for grammar parser.
public class State extends StateBase<foundation.rpg.sample.language.ast.Program> {
    private final foundation.rpg.sample.language.ast.AstFactory factory;

    public State(foundation.rpg.sample.language.ast.AstFactory factory) {
        this.factory = factory;
    }

    public foundation.rpg.sample.language.ast.AstFactory getFactory() {
        return factory;
    }

    // Ignored:
    public State visitWhiteSpace(foundation.rpg.common.symbols.WhiteSpace symbol) {
        return this;
    }

    public State visitComment(foundation.rpg.common.symbols.Comment symbol) {
        return this;
    }


// Symbols:
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitDot(foundation.rpg.common.symbols.Dot symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitGt(foundation.rpg.common.symbols.Gt symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPlus(foundation.rpg.common.symbols.Plus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitTimes(foundation.rpg.common.symbols.Times symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitIdentifier(foundation.rpg.sample.language.ast.Identifier symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRPar(foundation.rpg.common.symbols.RPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitComma(foundation.rpg.common.symbols.Comma symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitProgram(foundation.rpg.sample.language.ast.Program symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList1ListOfStatement(java.util.List<foundation.rpg.sample.language.ast.Statement> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitStatement(foundation.rpg.sample.language.ast.Statement symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitExpression(foundation.rpg.sample.language.ast.Expression symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRelationalExpression(foundation.rpg.sample.language.ast.Expression symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitAdditiveExpression(foundation.rpg.sample.language.ast.Expression symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitMultiplicativeExpression(foundation.rpg.sample.language.ast.Expression symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitAtomicExpression(foundation.rpg.sample.language.ast.Expression symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList3ListOfExpression(java.util.List<foundation.rpg.sample.language.ast.Expression> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList2ListOfExpression(java.util.List<foundation.rpg.sample.language.ast.Expression> symbol) throws UnexpectedInputException {
        return error(symbol);
    }


}
