/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.sample.json;

import foundation.rpg.common.Colon;
import foundation.rpg.common.Comma;
import foundation.rpg.common.LBr;
import foundation.rpg.common.LCurl;
import foundation.rpg.common.RBr;
import foundation.rpg.common.RCurl;
import foundation.rpg.common.WhiteSpace;
import foundation.rpg.parser.End;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.KeywordLexerBase;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.ParseErrorException;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.Token;
import foundation.rpg.sample.json.State;
import foundation.rpg.sample.json.TokenColon;
import foundation.rpg.sample.json.TokenComma;
import foundation.rpg.sample.json.TokenDouble;
import foundation.rpg.sample.json.TokenEnd;
import foundation.rpg.sample.json.TokenInteger;
import foundation.rpg.sample.json.TokenLBr;
import foundation.rpg.sample.json.TokenLCurl;
import foundation.rpg.sample.json.TokenRBr;
import foundation.rpg.sample.json.TokenRCurl;
import foundation.rpg.sample.json.TokenString;
import foundation.rpg.sample.json.TokenWhiteSpace;
import java.io.IOException;

public class JsonLexer
extends KeywordLexerBase<State>
implements Lexer<State> {
    public JsonLexer() {
        super((KeywordLexerBase.LiteralFactory)new KeywordLexerBase.LiteralFactory<State>(){

            public Token<State> newIdentifier(Position position, String name) {
                return new TokenString(name);
            }

            public Token<State> newString(Position position, String value) {
                return new TokenString(value);
            }

            public Token<State> newDouble(Position position, String value) {
                return new TokenDouble(Double.parseDouble(value));
            }

            public Token<State> newInteger(Position position, String value) {
                return new TokenInteger(Integer.parseInt(value));
            }

            public Token<State> newWhitespace(Position position, String value) {
                return new TokenWhiteSpace(new WhiteSpace(position));
            }
        });
    }

    public Token<State> next(Input input) throws ParseErrorException, IOException {
        Position mark = input.position();
        if (input.lookahead() < 0) {
            return new TokenEnd(new End(mark));
        }
        char lookahead = (char)input.lookahead();
        input.move();
        switch (lookahead) {
            case ',': {
                return new TokenComma(new Comma(mark));
            }
            case '{': {
                return new TokenLCurl(new LCurl(mark));
            }
            case '}': {
                return new TokenRCurl(new RCurl(mark));
            }
            case '[': {
                return new TokenLBr(new LBr(mark));
            }
            case ']': {
                return new TokenRBr(new RBr(mark));
            }
            case ':': {
                return new TokenColon(new Colon(mark));
            }
            case '\"': {
                return this.string(mark, input);
            }
        }
        return this.groups(mark, lookahead, input);
    }
}

