/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular;

import foundation.rpg.dfa.DFA;
import foundation.rpg.dfa.StateSet;
import foundation.rpg.gnfa.State;
import foundation.rpg.parser.Element;
import foundation.rpg.parser.End;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.TokenBuilder;
import foundation.rpg.util.Bfs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public class RegularGenerator {
    private String escape(Object e) {
        return e.toString().replace("\\", "\\\\").replace("'", "\\'");
    }

    private void i(PrintWriter w, Class<?> ... t) {
        for (Class<?> c : t) {
            w.println("import " + c.getCanonicalName() + ";");
        }
    }

    public <T> void generate(String pkg, String name, DFA dfa, Map<State, T> finalStates, PrintWriter ow, Function<Set<T>, String> prioritizer, TypeMirror factoryType) {
        try (PrintWriter w = ow;){
            HashMap<StateSet, Integer> states = new HashMap<StateSet, Integer>();
            w.println("package " + pkg + ";");
            w.println();
            this.i(w, Element.class, Lexer.class, Input.class, Position.class, End.class, IOException.class, TokenBuilder.class);
            w.println();
            w.println("public class " + name + " implements Lexer<State> {");
            if (Objects.nonNull(factoryType)) {
                w.println("\tprivate final " + factoryType + " factory;");
                w.println();
                w.println("\tpublic " + name + "(" + factoryType + " factory) {");
                w.println("\t\tthis.factory = factory;");
                w.println("\t}");
                w.println();
                w.println("\tpublic " + factoryType + " getFactory() {");
                w.println("\t\treturn factory;");
                w.println("\t}");
                w.println();
            }
            w.println("\tpublic Element<State> next(Input input) throws IOException {");
            w.println("\t\tint state = " + states.computeIfAbsent(dfa.getStart(), k -> states.size()) + ";");
            w.println("\t\tint symbol = input.lookahead();");
            w.println("\t\tTokenBuilder builder = new TokenBuilder(input);");
            w.println("\t\tif(symbol < 0) return visitor -> visitor.visitEnd(new End(builder.build()));");
            w.println("\t\tfor(; true; symbol = builder.next()) {");
            w.println("\t\t\tswitch(state) {");
            Bfs.withItem((Object)dfa.getStart(), (item, consumer) -> {
                Consumer<String> r = pref -> {
                    item.getGroupTransitions().forEach((atom, nextSet) -> {
                        w.println(pref + "\t\t\t\t\tif(Lexer.matchesGroup('" + atom + "', symbol)) { state = " + states.computeIfAbsent((StateSet)nextSet, k -> states.size()) + "; break; }");
                        consumer.accept(nextSet);
                    });
                    Set results = item.getStates().stream().filter(finalStates::containsKey).map(finalStates::get).collect(Collectors.toSet());
                    if (!StateSet.isError((StateSet)item.getDefaultState())) {
                        w.println(pref + "\t\t\t\t\tif(symbol < 0) throw new IllegalStateException(\"\");");
                        w.println(pref + "\t\t\t\t\tstate = " + states.computeIfAbsent(item.getDefaultState(), k -> states.size()) + "; break;");
                        consumer.accept(item.getDefaultState());
                    } else if (results.isEmpty()) {
                        w.println(pref + "\t\t\t\t\tthrow new IllegalStateException(\"\");");
                    } else {
                        String type = (String)prioritizer.apply(results);
                        w.println(pref + "\t\t\t\t\treturn visitor -> visitor." + type + ";");
                    }
                };
                w.println("\t\t\t\tcase " + states.computeIfAbsent((StateSet)item, k -> states.size()) + ":");
                int cases = item.getCharTransitions().size();
                if (cases > 1) {
                    w.println("\t\t\t\t\tswitch(symbol) {");
                    item.getCharTransitions().forEach((atom, nextSet) -> {
                        w.println("\t\t\t\t\t\tcase '" + this.escape(atom) + "': " + this.stateBranch((StateSet)nextSet, states));
                        consumer.accept(nextSet);
                    });
                    w.println("\t\t\t\t\t\tdefault:");
                    r.accept("\t\t");
                    w.println("\t\t\t\t\t}");
                    w.println("\t\t\t\t\tbreak;");
                } else {
                    item.getCharTransitions().forEach((atom, nextSet) -> {
                        w.println("\t\t\t\t\tif(symbol == '" + this.escape(atom) + "') { " + this.stateBranch((StateSet)nextSet, states) + " }");
                        consumer.accept(nextSet);
                    });
                    r.accept("");
                }
            });
            w.println("\t\t\t}");
            w.println("\t\t}");
            w.println("\t}");
            w.println("}");
            w.flush();
        }
    }

    private String stateBranch(StateSet stateSet, Map<StateSet, Integer> states) {
        return StateSet.isError((StateSet)stateSet) ? "throw new IllegalStateException(\"\");" : "state = " + states.computeIfAbsent(stateSet, k -> states.size()) + "; break;";
    }
}

