/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular;

import foundation.rpg.StartSymbol;
import foundation.rpg.SymbolPart;
import foundation.rpg.common.symbols.Bs;
import foundation.rpg.common.symbols.Dot;
import foundation.rpg.common.symbols.LBr;
import foundation.rpg.common.symbols.LPar;
import foundation.rpg.common.symbols.Minus;
import foundation.rpg.common.symbols.Pipe;
import foundation.rpg.common.symbols.Plus;
import foundation.rpg.common.symbols.RBr;
import foundation.rpg.common.symbols.RPar;
import foundation.rpg.common.symbols.Star;
import foundation.rpg.common.symbols.Up;
import foundation.rpg.gnfa.GNFA;
import foundation.rpg.gnfa.Thompson;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RegularGNFAFactory {
    private final Thompson thompson;

    public RegularGNFAFactory(Thompson thompson) {
        this.thompson = thompson;
    }

    @StartSymbol
    @Pattern
    GNFA is() {
        return this.thompson.empty();
    }

    @Pattern
    GNFA is(@Chain Stream<GNFA> l) {
        return this.thompson.alternation(l);
    }

    @Chain
    Stream<GNFA> is(@Chain GNFA c) {
        return Stream.of(c);
    }

    @Chain
    Stream<GNFA> is(@Chain Stream<GNFA> l, Pipe p, @Chain GNFA c) {
        return Stream.concat(l, Stream.of(c));
    }

    @Chain
    GNFA is1(@Node Stream<GNFA> l) {
        return this.thompson.chain(l);
    }

    @Node
    Stream<GNFA> is1(@Node GNFA g) {
        return Stream.of(g);
    }

    @Node
    Stream<GNFA> is1(@Node Stream<GNFA> l, @Node GNFA g) {
        return Stream.concat(l, Stream.of(g));
    }

    @Node
    GNFA is(LPar l, @Pattern GNFA p, RPar r) {
        return p;
    }

    @Node
    GNFA is(@Node GNFA a, Star t) {
        return this.thompson.repetition(a);
    }

    @Node
    GNFA is(@Node GNFA a, Plus p) {
        return this.thompson.chain(Stream.of(a, this.thompson.repetition(a)));
    }

    @Node
    GNFA is(Character c) {
        return this.thompson.transition(c);
    }

    @Node
    GNFA is(Dot d) {
        return this.thompson.any();
    }

    @Node
    GNFA is(Bs b, Character g) {
        return this.thompson.group(g);
    }

    @Node
    GNFA is(Bs b, Bs g) {
        return this.is(Character.valueOf('\\'));
    }

    @Node
    GNFA is(Bs b, Dot d) {
        return this.is(Character.valueOf('.'));
    }

    @Node
    GNFA is(Bs b, Star s) {
        return this.is(Character.valueOf('*'));
    }

    @Node
    GNFA is(Bs b, LBr s) {
        return this.is(Character.valueOf('['));
    }

    @Node
    GNFA is(Up u) {
        return this.is(Character.valueOf('^'));
    }

    @Node
    GNFA is(LBr l, @Chars Stream<Character> i, RBr r) {
        return this.thompson.transitions(i);
    }

    @Node
    GNFA is(LBr l, Up t, @Chars Stream<Character> i, RBr r) {
        return this.thompson.inversions(i);
    }

    @Chars
    Stream<Character> is2(Stream<Character> s) {
        return s;
    }

    @Chars
    Stream<Character> is(@Chars Stream<Character> s1, Stream<Character> s2) {
        return Stream.concat(s1, s2);
    }

    Stream<Character> is1(Character c) {
        return Stream.of(c);
    }

    Stream<Character> is1(Dot dot) {
        return this.is1(Character.valueOf('.'));
    }

    Stream<Character> is1(Star s) {
        return this.is1(Character.valueOf('*'));
    }

    Stream<Character> is1(LBr s) {
        return this.is1(Character.valueOf('['));
    }

    Stream<Character> is1(Pipe s) {
        return this.is1(Character.valueOf('|'));
    }

    Stream<Character> is1(Bs bs, Bs b) {
        return this.is1(Character.valueOf('\\'));
    }

    Stream<Character> is1(Bs bs, RBr b) {
        return this.is1(Character.valueOf(']'));
    }

    Stream<Character> is(Character s, Minus m, Character e) {
        return IntStream.rangeClosed(s.charValue(), e.charValue()).mapToObj(i -> Character.valueOf((char)i));
    }

    @SymbolPart
    static @interface Chars {
    }

    @SymbolPart
    static @interface Node {
    }

    @SymbolPart
    static @interface Chain {
    }

    @SymbolPart
    static @interface Pattern {
    }
}

