/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer;

import foundation.rpg.dfa.DFA;
import foundation.rpg.dfa.GNFATransformer;
import foundation.rpg.gnfa.GNFA;
import foundation.rpg.gnfa.Thompson;
import foundation.rpg.lexer.regular.RegularGenerator;
import foundation.rpg.lexer.regular.RegularTypes;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class LexerGenerator {
    private final GNFATransformer transformer = new GNFATransformer((GNFATransformer.Types)new RegularTypes());
    private final RegularGenerator generator = new RegularGenerator();

    public void generateLexer(String pkg, String name, List<TokenInfo> info, PrintWriter w, TypeMirror factoryType) {
        HashMap finalStates = new HashMap();
        GNFA gnfa = new Thompson().alternation(info.stream().map(i -> {
            finalStates.put(i.getPattern().getEnd(), i);
            return i.getPattern();
        }));
        DFA dfa = this.transformer.transform(gnfa);
        Comparator<TokenInfo> comparator = Comparator.comparingInt(TokenInfo::getPriority);
        this.generator.generate(pkg, name, dfa, finalStates, w, set -> ((TokenInfo)set.stream().max(comparator).orElseThrow(() -> new IllegalArgumentException(""))).call, factoryType);
    }

    public static class TokenInfo {
        private final Object element;
        private final String call;
        private final GNFA pattern;
        private final int priority;

        public TokenInfo(Object element, String call, GNFA pattern, int priority) {
            this.element = element;
            this.call = call;
            this.pattern = pattern;
            this.priority = priority;
        }

        public Object getElement() {
            return this.element;
        }

        public GNFA getPattern() {
            return this.pattern;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

