/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

Pipe1: {
	ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe • ChainGNFA [End, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [End, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [End, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [End, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LPar PatternGNFA RPar [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Star [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Plus [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Character [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Dot [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Character [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Bs [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Dot [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Star [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs LBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Up [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StatePipe1 extends StackState<foundation.rpg.common.symbols.Pipe, StackState<java.util.stream.Stream<foundation.rpg.gnfa.GNFA>, ? extends State>> {

// NoStack:
// Stack:
    public StatePipe1(foundation.rpg.lexer.regular.RegularGNFAFactory factory, foundation.rpg.common.symbols.Pipe node, StackState<java.util.stream.Stream<foundation.rpg.gnfa.GNFA>, ? extends State> prev) {
        super(factory, node, prev);
    }


// Reduce:
// Shift:
    @Override
    public State visitChainGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateChainGNFA3(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) {
        return new StateNodeStreamOfGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateNodeGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar1(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter1(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot1(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs1(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp1(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr1(getFactory(), symbol, this);
    }


// Accept:
}
