/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

NodeStreamOfGNFA1: {
	ChainGNFA -> NodeStreamOfGNFA • [End, Pipe]
	NodeStreamOfGNFA -> NodeStreamOfGNFA • NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Star [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Plus [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Character [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Dot [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Character [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Bs [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Dot [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Star [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs LBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Up [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateNodeStreamOfGNFA1 extends StackState<java.util.stream.Stream<foundation.rpg.gnfa.GNFA>, State> {

// NoStack:
// Stack:
    public StateNodeStreamOfGNFA1(foundation.rpg.lexer.regular.RegularGNFAFactory factory, java.util.stream.Stream<foundation.rpg.gnfa.GNFA> node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
    @Override
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        
		State stack1 = this.getPrev();
        return stack1.visitChainGNFA(getFactory().is1(this.getNode())).visitEnd(symbol);
    }

    @Override
    public State visitPipe(foundation.rpg.common.symbols.Pipe symbol) throws UnexpectedInputException {
        
		State stack1 = this.getPrev();
        return stack1.visitChainGNFA(getFactory().is1(this.getNode())).visitPipe(symbol);
    }


// Shift:
    @Override
    public State visitNodeGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateNodeGNFA2(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar1(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter1(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot1(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs1(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp1(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr1(getFactory(), symbol, this);
    }


// Accept:
}
