/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

LPar1: {
	NodeGNFA -> LPar • PatternGNFA RPar [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	PatternGNFA -> • [RPar]
	PatternGNFA -> • ChainStreamOfGNFA [RPar]
	ChainStreamOfGNFA -> • ChainGNFA [RPar, Pipe]
	ChainStreamOfGNFA -> • ChainStreamOfGNFA Pipe ChainGNFA [RPar, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [RPar, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Plus [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Bs [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs LBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Up [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateLPar1 extends StackState<foundation.rpg.common.symbols.LPar, State> {

// NoStack:
// Stack:
    public StateLPar1(foundation.rpg.lexer.regular.RegularGNFAFactory factory, foundation.rpg.common.symbols.LPar node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
    @Override
    public State visitRPar(foundation.rpg.common.symbols.RPar symbol) throws UnexpectedInputException {
        
        return this.visitPatternGNFA(getFactory().is()).visitRPar(symbol);
    }


// Shift:
    @Override
    public State visitPatternGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StatePatternGNFA2(getFactory(), symbol, this);
    }

    @Override
    public State visitChainStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) {
        return new StateChainStreamOfGNFA2(getFactory(), symbol, this);
    }

    @Override
    public State visitChainGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateChainGNFA2(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) {
        return new StateNodeStreamOfGNFA2(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateNodeGNFA3(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar3(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter3(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot3(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs3(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp3(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr3(getFactory(), symbol, this);
    }


// Accept:
}
