/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

Bs1: {
	NodeGNFA -> Bs • Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Bs [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • LBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateBs1 extends StackState<foundation.rpg.common.symbols.Bs, State> {

// NoStack:
// Stack:
    public StateBs1(foundation.rpg.lexer.regular.RegularGNFAFactory factory, foundation.rpg.common.symbols.Bs node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
// Shift:
    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter4(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs4(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot4(getFactory(), symbol, this);
    }

    @Override
    public State visitStar(foundation.rpg.common.symbols.Star symbol) {
        return new StateStar2(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr4(getFactory(), symbol, this);
    }


// Accept:
}
