/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

1: {
	Start -> • PatternGNFA End []
	PatternGNFA -> • [End]
	PatternGNFA -> • ChainStreamOfGNFA [End]
	ChainStreamOfGNFA -> • ChainGNFA [End, Pipe]
	ChainStreamOfGNFA -> • ChainStreamOfGNFA Pipe ChainGNFA [End, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [End, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Plus [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Bs [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs LBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Up [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class State1 extends State {

// NoStack:
    public State1(foundation.rpg.lexer.regular.RegularGNFAFactory factory) {
        super(factory);
    }


// Stack:
// Reduce:
    @Override
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        
        return this.visitPatternGNFA(getFactory().is()).visitEnd(symbol);
    }


// Shift:
    @Override
    public State visitPatternGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StatePatternGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitChainStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) {
        return new StateChainStreamOfGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitChainGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateChainGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) {
        return new StateNodeStreamOfGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitNodeGNFA(foundation.rpg.gnfa.GNFA symbol) {
        return new StateNodeGNFA1(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar1(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter1(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot1(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs1(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp1(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr1(getFactory(), symbol, this);
    }


// Accept:
}
