/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

N = [Start, PatternGNFA, ChainStreamOfGNFA, ChainGNFA, NodeStreamOfGNFA, NodeGNFA, CharsStreamOfCharacter, StreamOfCharacter]
T = [End, Pipe, LPar, RPar, Star, Plus, Character, Dot, Bs, LBr, Up, RBr, Minus]
S = Start
R = {
	Start -> PatternGNFA,End
	PatternGNFA -> 
	PatternGNFA -> ChainStreamOfGNFA
	ChainStreamOfGNFA -> ChainGNFA
	ChainStreamOfGNFA -> ChainStreamOfGNFA,Pipe,ChainGNFA
	ChainGNFA -> NodeStreamOfGNFA
	NodeStreamOfGNFA -> NodeGNFA
	NodeStreamOfGNFA -> NodeStreamOfGNFA,NodeGNFA
	NodeGNFA -> LPar,PatternGNFA,RPar
	NodeGNFA -> NodeGNFA,Star
	NodeGNFA -> NodeGNFA,Plus
	NodeGNFA -> Character
	NodeGNFA -> Dot
	NodeGNFA -> Bs,Character
	NodeGNFA -> Bs,Bs
	NodeGNFA -> Bs,Dot
	NodeGNFA -> Bs,Star
	NodeGNFA -> Bs,LBr
	NodeGNFA -> Up
	NodeGNFA -> LBr,CharsStreamOfCharacter,RBr
	NodeGNFA -> LBr,Up,CharsStreamOfCharacter,RBr
	CharsStreamOfCharacter -> StreamOfCharacter
	CharsStreamOfCharacter -> CharsStreamOfCharacter,StreamOfCharacter
	StreamOfCharacter -> Character
	StreamOfCharacter -> Dot
	StreamOfCharacter -> Star
	StreamOfCharacter -> LBr
	StreamOfCharacter -> Pipe
	StreamOfCharacter -> Bs,Bs
	StreamOfCharacter -> Bs,RBr
	StreamOfCharacter -> Character,Minus,Character
}

1: {
	Start -> • PatternGNFA End []
	PatternGNFA -> • [End]
	PatternGNFA -> • ChainStreamOfGNFA [End]
	ChainStreamOfGNFA -> • ChainGNFA [End, Pipe]
	ChainStreamOfGNFA -> • ChainStreamOfGNFA Pipe ChainGNFA [End, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [End, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Plus [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Bs [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs LBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Up [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
PatternGNFA1: {
	Start -> PatternGNFA • End []
}
ChainStreamOfGNFA1: {
	PatternGNFA -> ChainStreamOfGNFA • [End]
	ChainStreamOfGNFA -> ChainStreamOfGNFA • Pipe ChainGNFA [End, Pipe]
}
ChainGNFA1: {
	ChainStreamOfGNFA -> ChainGNFA • [End, Pipe]
}
NodeStreamOfGNFA1: {
	ChainGNFA -> NodeStreamOfGNFA • [End, Pipe]
	NodeStreamOfGNFA -> NodeStreamOfGNFA • NodeGNFA [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Star [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Plus [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Character [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Dot [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Character [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Bs [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Dot [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Star [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs LBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Up [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
}
NodeGNFA1: {
	NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Plus [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LPar1: {
	NodeGNFA -> LPar • PatternGNFA RPar [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	PatternGNFA -> • [RPar]
	PatternGNFA -> • ChainStreamOfGNFA [RPar]
	ChainStreamOfGNFA -> • ChainGNFA [RPar, Pipe]
	ChainStreamOfGNFA -> • ChainStreamOfGNFA Pipe ChainGNFA [RPar, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [RPar, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Plus [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Bs [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs LBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Up [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Character1: {
	NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Dot1: {
	NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Bs1: {
	NodeGNFA -> Bs • Character [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Bs [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Dot [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Star [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • LBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Up1: {
	NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LBr1: {
	NodeGNFA -> LBr • CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> LBr • Up CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	CharsStreamOfCharacter -> • CharsStreamOfCharacter StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
End1: {
	Start -> PatternGNFA End • []
}
Pipe1: {
	ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe • ChainGNFA [End, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [End, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [End, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [End, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LPar PatternGNFA RPar [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Star [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Plus [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Character [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Dot [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Character [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Bs [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Dot [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Star [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs LBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Up [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [End, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
}
NodeGNFA2: {
	NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Star [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> NodeGNFA • Plus [End, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
}
Star1: {
	NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Plus1: {
	NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
PatternGNFA2: {
	NodeGNFA -> LPar PatternGNFA • RPar [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
ChainStreamOfGNFA2: {
	PatternGNFA -> ChainStreamOfGNFA • [RPar]
	ChainStreamOfGNFA -> ChainStreamOfGNFA • Pipe ChainGNFA [RPar, Pipe]
}
ChainGNFA2: {
	ChainStreamOfGNFA -> ChainGNFA • [RPar, Pipe]
}
NodeStreamOfGNFA2: {
	ChainGNFA -> NodeStreamOfGNFA • [RPar, Pipe]
	NodeStreamOfGNFA -> NodeStreamOfGNFA • NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Star [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • NodeGNFA Plus [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Character [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Dot [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Character [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Bs [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Dot [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs Star [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Bs LBr [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • Up [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
}
NodeGNFA3: {
	NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Plus [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LPar3: {
	NodeGNFA -> LPar • PatternGNFA RPar [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	PatternGNFA -> • [RPar]
	PatternGNFA -> • ChainStreamOfGNFA [RPar]
	ChainStreamOfGNFA -> • ChainGNFA [RPar, Pipe]
	ChainStreamOfGNFA -> • ChainStreamOfGNFA Pipe ChainGNFA [RPar, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [RPar, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LPar PatternGNFA RPar [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • NodeGNFA Plus [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Bs [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Bs LBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • Up [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Character3: {
	NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Dot3: {
	NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Bs3: {
	NodeGNFA -> Bs • Character [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Bs [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Dot [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • Star [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> Bs • LBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Up3: {
	NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LBr3: {
	NodeGNFA -> LBr • CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> LBr • Up CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	CharsStreamOfCharacter -> • CharsStreamOfCharacter StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Character4: {
	NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Bs4: {
	NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Dot4: {
	NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Star2: {
	NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LBr4: {
	NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
CharsStreamOfCharacter1: {
	NodeGNFA -> LBr CharsStreamOfCharacter • RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> CharsStreamOfCharacter • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Up4: {
	NodeGNFA -> LBr Up • CharsStreamOfCharacter RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	CharsStreamOfCharacter -> • CharsStreamOfCharacter StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
StreamOfCharacter1: {
	CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Character5: {
	StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> Character • Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Dot5: {
	StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Star3: {
	StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
LBr5: {
	StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Pipe2: {
	StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Bs5: {
	StreamOfCharacter -> Bs • Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> Bs • RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
ChainGNFA3: {
	ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [End, Pipe]
}
RPar1: {
	NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Pipe3: {
	ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe • ChainGNFA [RPar, Pipe]
	ChainGNFA -> • NodeStreamOfGNFA [RPar, Pipe]
	NodeStreamOfGNFA -> • NodeGNFA [RPar, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeStreamOfGNFA -> • NodeStreamOfGNFA NodeGNFA [RPar, Pipe, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LPar PatternGNFA RPar [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Star [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • NodeGNFA Plus [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Character [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Dot [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Character [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Bs [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Dot [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs Star [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Bs LBr [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • Up [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr CharsStreamOfCharacter RBr [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
	NodeGNFA -> • LBr Up CharsStreamOfCharacter RBr [RPar, Pipe, Star, Plus, LPar, Character, Dot, Bs, Up, LBr]
}
NodeGNFA5: {
	NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	NodeGNFA -> NodeGNFA • Star [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
	NodeGNFA -> NodeGNFA • Plus [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe, Star, Plus]
}
Star5: {
	NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Plus3: {
	NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
PatternGNFA3: {
	NodeGNFA -> LPar PatternGNFA • RPar [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Character9: {
	NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Bs9: {
	NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Dot9: {
	NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Star6: {
	NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
LBr9: {
	NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
CharsStreamOfCharacter2: {
	NodeGNFA -> LBr CharsStreamOfCharacter • RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> CharsStreamOfCharacter • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Up8: {
	NodeGNFA -> LBr Up • CharsStreamOfCharacter RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	CharsStreamOfCharacter -> • CharsStreamOfCharacter StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr1: {
	NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
StreamOfCharacter3: {
	CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
CharsStreamOfCharacter3: {
	NodeGNFA -> LBr Up CharsStreamOfCharacter • RBr [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> CharsStreamOfCharacter • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Minus1: {
	StreamOfCharacter -> Character Minus • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Bs13: {
	StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr2: {
	StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
ChainGNFA5: {
	ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [RPar, Pipe]
}
RPar2: {
	NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
RBr3: {
	NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
CharsStreamOfCharacter4: {
	NodeGNFA -> LBr Up CharsStreamOfCharacter • RBr [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
	CharsStreamOfCharacter -> CharsStreamOfCharacter • StreamOfCharacter [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	StreamOfCharacter -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr4: {
	NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}
Character17: {
	StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr5: {
	NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
}

1: End -> REDUCE: PatternGNFA -> • [End]
1: PatternGNFA -> GOTO: PatternGNFA1
1: ChainStreamOfGNFA -> GOTO: ChainStreamOfGNFA1
1: ChainGNFA -> GOTO: ChainGNFA1
1: NodeStreamOfGNFA -> GOTO: NodeStreamOfGNFA1
1: NodeGNFA -> GOTO: NodeGNFA1
1: LPar -> GOTO: LPar1
1: Character -> GOTO: Character1
1: Dot -> GOTO: Dot1
1: Bs -> GOTO: Bs1
1: Up -> GOTO: Up1
1: LBr -> GOTO: LBr1
PatternGNFA1: End -> GOTO: End1
ChainStreamOfGNFA1: End -> REDUCE: PatternGNFA -> ChainStreamOfGNFA • [End]
ChainStreamOfGNFA1: Pipe -> GOTO: Pipe1
ChainGNFA1: End -> REDUCE: ChainStreamOfGNFA -> ChainGNFA • [End, Pipe]
ChainGNFA1: Pipe -> REDUCE: ChainStreamOfGNFA -> ChainGNFA • [End, Pipe]
NodeStreamOfGNFA1: End -> REDUCE: ChainGNFA -> NodeStreamOfGNFA • [End, Pipe]
NodeStreamOfGNFA1: Pipe -> REDUCE: ChainGNFA -> NodeStreamOfGNFA • [End, Pipe]
NodeStreamOfGNFA1: NodeGNFA -> GOTO: NodeGNFA2
NodeStreamOfGNFA1: LPar -> GOTO: LPar1
NodeStreamOfGNFA1: Character -> GOTO: Character1
NodeStreamOfGNFA1: Dot -> GOTO: Dot1
NodeStreamOfGNFA1: Bs -> GOTO: Bs1
NodeStreamOfGNFA1: Up -> GOTO: Up1
NodeStreamOfGNFA1: LBr -> GOTO: LBr1
NodeGNFA1: End -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: LPar -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Character -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Dot -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Bs -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Up -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: LBr -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Pipe -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA1: Star -> GOTO: Star1
NodeGNFA1: Plus -> GOTO: Plus1
LPar1: RPar -> REDUCE: PatternGNFA -> • [RPar]
LPar1: PatternGNFA -> GOTO: PatternGNFA2
LPar1: ChainStreamOfGNFA -> GOTO: ChainStreamOfGNFA2
LPar1: ChainGNFA -> GOTO: ChainGNFA2
LPar1: NodeStreamOfGNFA -> GOTO: NodeStreamOfGNFA2
LPar1: NodeGNFA -> GOTO: NodeGNFA3
LPar1: LPar -> GOTO: LPar3
LPar1: Character -> GOTO: Character3
LPar1: Dot -> GOTO: Dot3
LPar1: Bs -> GOTO: Bs3
LPar1: Up -> GOTO: Up3
LPar1: LBr -> GOTO: LBr3
Character1: End -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Star -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Plus -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: LPar -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Character -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Dot -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Bs -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Up -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: LBr -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character1: Pipe -> REDUCE: NodeGNFA -> Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: End -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Star -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Plus -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: LPar -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Character -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Dot -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Bs -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Up -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: LBr -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot1: Pipe -> REDUCE: NodeGNFA -> Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs1: Character -> GOTO: Character4
Bs1: Bs -> GOTO: Bs4
Bs1: Dot -> GOTO: Dot4
Bs1: Star -> GOTO: Star2
Bs1: LBr -> GOTO: LBr4
Up1: End -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Star -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Plus -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: LPar -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Character -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Dot -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Bs -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Up -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: LBr -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up1: Pipe -> REDUCE: NodeGNFA -> Up • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr1: CharsStreamOfCharacter -> GOTO: CharsStreamOfCharacter1
LBr1: Up -> GOTO: Up4
LBr1: StreamOfCharacter -> GOTO: StreamOfCharacter1
LBr1: Character -> GOTO: Character5
LBr1: Dot -> GOTO: Dot5
LBr1: Star -> GOTO: Star3
LBr1: LBr -> GOTO: LBr5
LBr1: Pipe -> GOTO: Pipe2
LBr1: Bs -> GOTO: Bs5
End1:  -> ACCEPT: Start -> PatternGNFA End • []
Pipe1: ChainGNFA -> GOTO: ChainGNFA3
Pipe1: NodeStreamOfGNFA -> GOTO: NodeStreamOfGNFA1
Pipe1: NodeGNFA -> GOTO: NodeGNFA1
Pipe1: LPar -> GOTO: LPar1
Pipe1: Character -> GOTO: Character1
Pipe1: Dot -> GOTO: Dot1
Pipe1: Bs -> GOTO: Bs1
Pipe1: Up -> GOTO: Up1
Pipe1: LBr -> GOTO: LBr1
NodeGNFA2: End -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: LPar -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Character -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Dot -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Bs -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Up -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: LBr -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Pipe -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [End, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA2: Star -> GOTO: Star1
NodeGNFA2: Plus -> GOTO: Plus1
Star1: End -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Star -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Plus -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: LPar -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Character -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Dot -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Bs -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Up -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: LBr -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star1: Pipe -> REDUCE: NodeGNFA -> NodeGNFA Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: End -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Star -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Plus -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: LPar -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Character -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Dot -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Bs -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Up -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: LBr -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus1: Pipe -> REDUCE: NodeGNFA -> NodeGNFA Plus • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
PatternGNFA2: RPar -> GOTO: RPar1
ChainStreamOfGNFA2: RPar -> REDUCE: PatternGNFA -> ChainStreamOfGNFA • [RPar]
ChainStreamOfGNFA2: Pipe -> GOTO: Pipe3
ChainGNFA2: RPar -> REDUCE: ChainStreamOfGNFA -> ChainGNFA • [RPar, Pipe]
ChainGNFA2: Pipe -> REDUCE: ChainStreamOfGNFA -> ChainGNFA • [RPar, Pipe]
NodeStreamOfGNFA2: RPar -> REDUCE: ChainGNFA -> NodeStreamOfGNFA • [RPar, Pipe]
NodeStreamOfGNFA2: Pipe -> REDUCE: ChainGNFA -> NodeStreamOfGNFA • [RPar, Pipe]
NodeStreamOfGNFA2: NodeGNFA -> GOTO: NodeGNFA5
NodeStreamOfGNFA2: LPar -> GOTO: LPar3
NodeStreamOfGNFA2: Character -> GOTO: Character3
NodeStreamOfGNFA2: Dot -> GOTO: Dot3
NodeStreamOfGNFA2: Bs -> GOTO: Bs3
NodeStreamOfGNFA2: Up -> GOTO: Up3
NodeStreamOfGNFA2: LBr -> GOTO: LBr3
NodeGNFA3: RPar -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: LPar -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Character -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Dot -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Bs -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Up -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: LBr -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Pipe -> REDUCE: NodeStreamOfGNFA -> NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA3: Star -> GOTO: Star5
NodeGNFA3: Plus -> GOTO: Plus3
LPar3: RPar -> REDUCE: PatternGNFA -> • [RPar]
LPar3: PatternGNFA -> GOTO: PatternGNFA3
LPar3: ChainStreamOfGNFA -> GOTO: ChainStreamOfGNFA2
LPar3: ChainGNFA -> GOTO: ChainGNFA2
LPar3: NodeStreamOfGNFA -> GOTO: NodeStreamOfGNFA2
LPar3: NodeGNFA -> GOTO: NodeGNFA3
LPar3: LPar -> GOTO: LPar3
LPar3: Character -> GOTO: Character3
LPar3: Dot -> GOTO: Dot3
LPar3: Bs -> GOTO: Bs3
LPar3: Up -> GOTO: Up3
LPar3: LBr -> GOTO: LBr3
Character3: RPar -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Star -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Plus -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: LPar -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Character -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Dot -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Bs -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Up -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: LBr -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character3: Pipe -> REDUCE: NodeGNFA -> Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: RPar -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Star -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Plus -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: LPar -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Character -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Dot -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Bs -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Up -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: LBr -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot3: Pipe -> REDUCE: NodeGNFA -> Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs3: Character -> GOTO: Character9
Bs3: Bs -> GOTO: Bs9
Bs3: Dot -> GOTO: Dot9
Bs3: Star -> GOTO: Star6
Bs3: LBr -> GOTO: LBr9
Up3: RPar -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Star -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Plus -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: LPar -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Character -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Dot -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Bs -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Up -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: LBr -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Up3: Pipe -> REDUCE: NodeGNFA -> Up • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr3: CharsStreamOfCharacter -> GOTO: CharsStreamOfCharacter2
LBr3: Up -> GOTO: Up8
LBr3: StreamOfCharacter -> GOTO: StreamOfCharacter1
LBr3: Character -> GOTO: Character5
LBr3: Dot -> GOTO: Dot5
LBr3: Star -> GOTO: Star3
LBr3: LBr -> GOTO: LBr5
LBr3: Pipe -> GOTO: Pipe2
LBr3: Bs -> GOTO: Bs5
Character4: End -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Star -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Plus -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: LPar -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Character -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Dot -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Bs -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Up -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: LBr -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character4: Pipe -> REDUCE: NodeGNFA -> Bs Character • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: End -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Star -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Plus -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: LPar -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Character -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Dot -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Bs -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Up -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: LBr -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs4: Pipe -> REDUCE: NodeGNFA -> Bs Bs • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: End -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Star -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Plus -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: LPar -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Character -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Dot -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Bs -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Up -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: LBr -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot4: Pipe -> REDUCE: NodeGNFA -> Bs Dot • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: End -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Star -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Plus -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: LPar -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Character -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Dot -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Bs -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Up -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: LBr -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star2: Pipe -> REDUCE: NodeGNFA -> Bs Star • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: End -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Star -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Plus -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: LPar -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Character -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Dot -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Bs -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Up -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: LBr -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr4: Pipe -> REDUCE: NodeGNFA -> Bs LBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
CharsStreamOfCharacter1: RBr -> GOTO: RBr1
CharsStreamOfCharacter1: StreamOfCharacter -> GOTO: StreamOfCharacter3
CharsStreamOfCharacter1: Character -> GOTO: Character5
CharsStreamOfCharacter1: Dot -> GOTO: Dot5
CharsStreamOfCharacter1: Star -> GOTO: Star3
CharsStreamOfCharacter1: LBr -> GOTO: LBr5
CharsStreamOfCharacter1: Pipe -> GOTO: Pipe2
CharsStreamOfCharacter1: Bs -> GOTO: Bs5
Up4: CharsStreamOfCharacter -> GOTO: CharsStreamOfCharacter3
Up4: StreamOfCharacter -> GOTO: StreamOfCharacter1
Up4: Character -> GOTO: Character5
Up4: Dot -> GOTO: Dot5
Up4: Star -> GOTO: Star3
Up4: LBr -> GOTO: LBr5
Up4: Pipe -> GOTO: Pipe2
Up4: Bs -> GOTO: Bs5
StreamOfCharacter1: RBr -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: Character -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: Dot -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: Star -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: LBr -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: Pipe -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter1: Bs -> REDUCE: CharsStreamOfCharacter -> StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: RBr -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Character -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Dot -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Star -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: LBr -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Pipe -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Bs -> REDUCE: StreamOfCharacter -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Minus -> GOTO: Minus1
Dot5: RBr -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Character -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Dot -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Star -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: LBr -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Pipe -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Bs -> REDUCE: StreamOfCharacter -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: RBr -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Character -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Dot -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Star -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: LBr -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Pipe -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Bs -> REDUCE: StreamOfCharacter -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: RBr -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Character -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Dot -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Star -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: LBr -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Pipe -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Bs -> REDUCE: StreamOfCharacter -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: RBr -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Character -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Dot -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Star -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: LBr -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Pipe -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Bs -> REDUCE: StreamOfCharacter -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs5: Bs -> GOTO: Bs13
Bs5: RBr -> GOTO: RBr2
ChainGNFA3: End -> REDUCE: ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [End, Pipe]
ChainGNFA3: Pipe -> REDUCE: ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [End, Pipe]
RPar1: End -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Star -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Plus -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: LPar -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Character -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Dot -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Bs -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Up -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: LBr -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar1: Pipe -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Pipe3: ChainGNFA -> GOTO: ChainGNFA5
Pipe3: NodeStreamOfGNFA -> GOTO: NodeStreamOfGNFA2
Pipe3: NodeGNFA -> GOTO: NodeGNFA3
Pipe3: LPar -> GOTO: LPar3
Pipe3: Character -> GOTO: Character3
Pipe3: Dot -> GOTO: Dot3
Pipe3: Bs -> GOTO: Bs3
Pipe3: Up -> GOTO: Up3
Pipe3: LBr -> GOTO: LBr3
NodeGNFA5: RPar -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: LPar -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Character -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Dot -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Bs -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Up -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: LBr -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Pipe -> REDUCE: NodeStreamOfGNFA -> NodeStreamOfGNFA NodeGNFA • [RPar, LPar, Character, Dot, Bs, Up, LBr, Pipe]
NodeGNFA5: Star -> GOTO: Star5
NodeGNFA5: Plus -> GOTO: Plus3
Star5: RPar -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Star -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Plus -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: LPar -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Character -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Dot -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Bs -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Up -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: LBr -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star5: Pipe -> REDUCE: NodeGNFA -> NodeGNFA Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: RPar -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Star -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Plus -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: LPar -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Character -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Dot -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Bs -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Up -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: LBr -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Plus3: Pipe -> REDUCE: NodeGNFA -> NodeGNFA Plus • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
PatternGNFA3: RPar -> GOTO: RPar2
Character9: RPar -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Star -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Plus -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: LPar -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Character -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Dot -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Bs -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Up -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: LBr -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character9: Pipe -> REDUCE: NodeGNFA -> Bs Character • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: RPar -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Star -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Plus -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: LPar -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Character -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Dot -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Bs -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Up -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: LBr -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Bs9: Pipe -> REDUCE: NodeGNFA -> Bs Bs • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: RPar -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Star -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Plus -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: LPar -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Character -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Dot -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Bs -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Up -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: LBr -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Dot9: Pipe -> REDUCE: NodeGNFA -> Bs Dot • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: RPar -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Star -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Plus -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: LPar -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Character -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Dot -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Bs -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Up -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: LBr -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Star6: Pipe -> REDUCE: NodeGNFA -> Bs Star • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: RPar -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Star -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Plus -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: LPar -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Character -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Dot -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Bs -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Up -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: LBr -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
LBr9: Pipe -> REDUCE: NodeGNFA -> Bs LBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
CharsStreamOfCharacter2: RBr -> GOTO: RBr3
CharsStreamOfCharacter2: StreamOfCharacter -> GOTO: StreamOfCharacter3
CharsStreamOfCharacter2: Character -> GOTO: Character5
CharsStreamOfCharacter2: Dot -> GOTO: Dot5
CharsStreamOfCharacter2: Star -> GOTO: Star3
CharsStreamOfCharacter2: LBr -> GOTO: LBr5
CharsStreamOfCharacter2: Pipe -> GOTO: Pipe2
CharsStreamOfCharacter2: Bs -> GOTO: Bs5
Up8: CharsStreamOfCharacter -> GOTO: CharsStreamOfCharacter4
Up8: StreamOfCharacter -> GOTO: StreamOfCharacter1
Up8: Character -> GOTO: Character5
Up8: Dot -> GOTO: Dot5
Up8: Star -> GOTO: Star3
Up8: LBr -> GOTO: LBr5
Up8: Pipe -> GOTO: Pipe2
Up8: Bs -> GOTO: Bs5
RBr1: End -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Star -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Plus -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: LPar -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Character -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Dot -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Bs -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Up -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: LBr -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr1: Pipe -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
StreamOfCharacter3: RBr -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: Character -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: Dot -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: Star -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: LBr -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: Pipe -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
StreamOfCharacter3: Bs -> REDUCE: CharsStreamOfCharacter -> CharsStreamOfCharacter StreamOfCharacter • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
CharsStreamOfCharacter3: RBr -> GOTO: RBr4
CharsStreamOfCharacter3: StreamOfCharacter -> GOTO: StreamOfCharacter3
CharsStreamOfCharacter3: Character -> GOTO: Character5
CharsStreamOfCharacter3: Dot -> GOTO: Dot5
CharsStreamOfCharacter3: Star -> GOTO: Star3
CharsStreamOfCharacter3: LBr -> GOTO: LBr5
CharsStreamOfCharacter3: Pipe -> GOTO: Pipe2
CharsStreamOfCharacter3: Bs -> GOTO: Bs5
Minus1: Character -> GOTO: Character17
Bs13: RBr -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Character -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Dot -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Star -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: LBr -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Pipe -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Bs -> REDUCE: StreamOfCharacter -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: RBr -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Character -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Dot -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Star -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: LBr -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Pipe -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Bs -> REDUCE: StreamOfCharacter -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
ChainGNFA5: RPar -> REDUCE: ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [RPar, Pipe]
ChainGNFA5: Pipe -> REDUCE: ChainStreamOfGNFA -> ChainStreamOfGNFA Pipe ChainGNFA • [RPar, Pipe]
RPar2: RPar -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Star -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Plus -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: LPar -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Character -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Dot -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Bs -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Up -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: LBr -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RPar2: Pipe -> REDUCE: NodeGNFA -> LPar PatternGNFA RPar • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: RPar -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Star -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Plus -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: LPar -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Character -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Dot -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Bs -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Up -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: LBr -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr3: Pipe -> REDUCE: NodeGNFA -> LBr CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
CharsStreamOfCharacter4: RBr -> GOTO: RBr5
CharsStreamOfCharacter4: StreamOfCharacter -> GOTO: StreamOfCharacter3
CharsStreamOfCharacter4: Character -> GOTO: Character5
CharsStreamOfCharacter4: Dot -> GOTO: Dot5
CharsStreamOfCharacter4: Star -> GOTO: Star3
CharsStreamOfCharacter4: LBr -> GOTO: LBr5
CharsStreamOfCharacter4: Pipe -> GOTO: Pipe2
CharsStreamOfCharacter4: Bs -> GOTO: Bs5
RBr4: End -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Star -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Plus -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: LPar -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Character -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Dot -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Bs -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Up -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: LBr -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr4: Pipe -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [End, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
Character17: RBr -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Character -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Dot -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Star -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: LBr -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Pipe -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Bs -> REDUCE: StreamOfCharacter -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr5: RPar -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Star -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Plus -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: LPar -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Character -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Dot -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Bs -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Up -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: LBr -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]
RBr5: Pipe -> REDUCE: NodeGNFA -> LBr Up CharsStreamOfCharacter RBr • [RPar, Star, Plus, LPar, Character, Dot, Bs, Up, LBr, Pipe]

*/

import foundation.rpg.parser.UnexpectedInputException;
import foundation.rpg.parser.StateBase;

// Generated visitor pattern based state for grammar parser.
public class State extends StateBase<foundation.rpg.gnfa.GNFA> {
    private final foundation.rpg.lexer.regular.RegularGNFAFactory factory;

    public State(foundation.rpg.lexer.regular.RegularGNFAFactory factory) {
        this.factory = factory;
    }

    public foundation.rpg.lexer.regular.RegularGNFAFactory getFactory() {
        return factory;
    }

    // Ignored:
// Symbols:
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPipe(foundation.rpg.common.symbols.Pipe symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRPar(foundation.rpg.common.symbols.RPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitStar(foundation.rpg.common.symbols.Star symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPlus(foundation.rpg.common.symbols.Plus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitCharacter(java.lang.Character symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitDot(foundation.rpg.common.symbols.Dot symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitBs(foundation.rpg.common.symbols.Bs symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitUp(foundation.rpg.common.symbols.Up symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRBr(foundation.rpg.common.symbols.RBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitMinus(foundation.rpg.common.symbols.Minus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPatternGNFA(foundation.rpg.gnfa.GNFA symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitChainStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitChainGNFA(foundation.rpg.gnfa.GNFA symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitNodeStreamOfGNFA(java.util.stream.Stream<foundation.rpg.gnfa.GNFA> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitNodeGNFA(foundation.rpg.gnfa.GNFA symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitCharsStreamOfCharacter(java.util.stream.Stream<java.lang.Character> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitStreamOfCharacter(java.util.stream.Stream<java.lang.Character> symbol) throws UnexpectedInputException {
        return error(symbol);
    }


}
