/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular.thompson;

import foundation.rpg.lexer.regular.Visitor;
import foundation.rpg.lexer.regular.ast.Chain;
import foundation.rpg.lexer.regular.ast.Char;
import foundation.rpg.lexer.regular.ast.CharClass;
import foundation.rpg.lexer.regular.ast.Empty;
import foundation.rpg.lexer.regular.ast.Group;
import foundation.rpg.lexer.regular.ast.Inversion;
import foundation.rpg.lexer.regular.ast.Item;
import foundation.rpg.lexer.regular.ast.Node;
import foundation.rpg.lexer.regular.ast.Pattern;
import foundation.rpg.lexer.regular.ast.Range;
import foundation.rpg.lexer.regular.ast.Repetition;
import foundation.rpg.lexer.regular.thompson.GNFA;
import foundation.rpg.lexer.regular.thompson.State;
import java.util.List;
import java.util.stream.IntStream;

public class ThompsonVisitor
implements Visitor<GNFA> {
    public static final Node epsilon = null;

    @Override
    public GNFA visit(Char character) {
        State start = new State();
        State end = new State();
        start.add(character, end);
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Group group) {
        State start = new State();
        State end = new State();
        start.add(group, end);
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Range range) {
        State start = new State();
        State end = new State();
        IntStream.rangeClosed(range.getStart(), range.getEnd()).forEach(i -> start.add(new Char(i), end));
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Inversion inversion) {
        State start = new State();
        State end = new State();
        start.add(inversion, end);
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Chain chain) {
        GNFA automata = chain.getOperands().get(0).accept(this);
        State start = automata.getStart();
        for (int i = 1; i < chain.getOperands().size(); ++i) {
            GNFA n = chain.getOperands().get(i).accept(this);
            automata.getEnd().add(epsilon, n.getStart());
            automata = n;
        }
        return new GNFA(start, automata.getEnd());
    }

    @Override
    public GNFA visit(Repetition repetition) {
        State start = new State();
        State end = new State();
        start.add(epsilon, end);
        GNFA automata = repetition.getPattern().accept(this);
        automata.getEnd().add(epsilon, automata.getStart());
        start.add(epsilon, automata.getStart());
        automata.getEnd().add(epsilon, end);
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Pattern union) {
        State start = new State();
        State end = new State();
        for (Node node : union.getOperands()) {
            GNFA automata = node.accept(this);
            start.add(epsilon, automata.getStart());
            automata.getEnd().add(epsilon, end);
        }
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(Empty empty) {
        State start = new State();
        State end = new State();
        start.add(epsilon, end);
        return new GNFA(start, end);
    }

    @Override
    public GNFA visit(CharClass charClass) {
        State start = new State();
        State end = new State();
        charClass.getItems().stream().flatMap(Item::getChars).map(Char::new).forEach(c -> start.add((Node)c, end));
        return new GNFA(start, end);
    }

    public GNFA visit(List<Node> patterns) {
        State start = new State();
        State end = new State();
        for (Node pattern : patterns) {
            GNFA automata = pattern.accept(this);
            start.add(epsilon, automata.getStart());
            automata.getEnd().setResult(pattern).add(epsilon, end);
        }
        return new GNFA(start, end);
    }
}

