/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular;

import foundation.rpg.lexer.regular.ast.Char;
import foundation.rpg.lexer.regular.ast.Item;
import foundation.rpg.lexer.regular.dfa.DFA;
import foundation.rpg.lexer.regular.dfa.StateSet;
import foundation.rpg.lexer.regular.thompson.State;
import foundation.rpg.parser.Element;
import foundation.rpg.parser.End;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.TokenBuilder;
import foundation.rpg.util.Bfs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public class RegularGenerator {
    private String escape(Object e) {
        return e.toString().replace("\\", "\\\\").replace("'", "\\'");
    }

    private void i(PrintWriter w, Class<?> ... t) {
        for (Class<?> c : t) {
            w.println("import " + c.getCanonicalName() + ";");
        }
    }

    public void generate(String pkg, String name, DFA dfa, PrintWriter ow, Function<Set<Object>, String> prioritizer, TypeMirror factoryType) {
        try (PrintWriter w = ow;){
            HashMap<StateSet, Integer> states = new HashMap<StateSet, Integer>();
            w.println("package " + pkg + ";");
            w.println();
            this.i(w, Element.class, Lexer.class, Input.class, Position.class, End.class, IOException.class, TokenBuilder.class);
            w.println();
            w.println("public class " + name + " implements Lexer<State> {");
            if (Objects.nonNull(factoryType)) {
                w.println("\tprivate final " + factoryType + " factory;");
                w.println();
                w.println("\tpublic " + name + "(" + factoryType + " factory) {");
                w.println("\t\tthis.factory = factory;");
                w.println("\t}");
                w.println();
                w.println("\tpublic " + factoryType + " getFactory() {");
                w.println("\t\treturn factory;");
                w.println("\t}");
                w.println();
            }
            w.println("\tpublic Element<State> next(Input input) throws IOException {");
            w.println("\t\tint state = " + states.computeIfAbsent(dfa.getStart(), k -> states.size()) + ";");
            w.println("\t\tint symbol = input.lookahead();");
            w.println("\t\tTokenBuilder builder = new TokenBuilder(input);");
            w.println("\t\tif(symbol < 0) return visitor -> visitor.visitEnd(new End(builder.build()));");
            w.println("\t\tfor(; true; symbol = builder.next()) {");
            w.println("\t\t\tswitch(state) {");
            Bfs.bfs((item, consumer) -> {
                Consumer<String> r = pref -> {
                    item.getGroupTransitions().forEach((atom, nextSet) -> {
                        w.println(pref + "\t\t\t\t\tif(Lexer.matchesGroup(\"" + atom.toString().substring(1) + "\", symbol)) { state = " + states.computeIfAbsent((StateSet)nextSet, k -> states.size()) + "; break; }");
                        consumer.accept(nextSet);
                    });
                    Set results = item.getStates().stream().filter(s -> Objects.nonNull(s.getResult())).map(State::getResult).collect(Collectors.toSet());
                    if (Objects.nonNull(item.getDefaultState())) {
                        w.println(pref + "\t\t\t\t\tif(symbol < 0) throw new IllegalStateException(\"\");");
                        w.println(pref + "\t\t\t\t\tstate = " + states.computeIfAbsent(item.getDefaultState(), k -> states.size()) + "; break;");
                        consumer.accept(item.getDefaultState());
                    } else if (results.isEmpty()) {
                        w.println(pref + "\t\t\t\t\tthrow new IllegalStateException(\"\");");
                    } else {
                        String type = (String)prioritizer.apply(results);
                        w.println(pref + "\t\t\t\t\treturn visitor -> visitor." + type + ";");
                    }
                };
                w.println("\t\t\t\tcase " + states.computeIfAbsent((StateSet)item, k -> states.size()) + ":");
                int cases = item.getCharTransitions().size() + item.getInversions().size();
                if (cases > 1) {
                    w.println("\t\t\t\t\tswitch(symbol) {");
                    item.getCharTransitions().forEach((atom, nextSet) -> {
                        w.println("\t\t\t\t\t\tcase '" + this.escape(atom) + "': state = " + states.computeIfAbsent((StateSet)nextSet, k -> states.size()) + "; break;");
                        consumer.accept(nextSet);
                    });
                    List<Character> invs = item.getInversions().stream().flatMap(inversion -> inversion.getCharClass().getItems().stream()).flatMap(Item::getChars).filter(c -> !item.getCharTransitions().containsKey(new Char(c.charValue()))).collect(Collectors.toList());
                    if (!invs.isEmpty()) {
                        invs.forEach(c -> w.println("\t\t\t\t\t\tcase '" + this.escape(c) + "':"));
                        w.println("\t\t\t\t\t\t\tthrow new IllegalStateException(\"\");");
                    }
                    w.println("\t\t\t\t\t\tdefault:");
                    r.accept("\t\t");
                    w.println("\t\t\t\t\t}");
                    w.println("\t\t\t\t\tbreak;");
                } else {
                    item.getCharTransitions().forEach((atom, nextSet) -> {
                        w.println("\t\t\t\t\tif(symbol == '" + this.escape(atom) + "') { state = " + states.computeIfAbsent((StateSet)nextSet, k -> states.size()) + "; break; }");
                        consumer.accept(nextSet);
                    });
                    item.getInversions().stream().flatMap(inversion -> inversion.getCharClass().getItems().stream()).flatMap(Item::getChars).filter(c -> !item.getCharTransitions().containsKey(new Char(c.charValue()))).forEach(c -> w.println("\t\t\t\t\tif(symbol == '" + this.escape(c) + "') throw new IllegalStateException(\"\");"));
                    r.accept("");
                }
            }, Collections.singleton(dfa.getStart()));
            w.println("\t\t\t}");
            w.println("\t\t}");
            w.println("\t}");
            w.println("}");
            w.flush();
        }
    }
}

