/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer;

import foundation.rpg.lexer.regular.RegularGenerator;
import foundation.rpg.lexer.regular.ast.Node;
import foundation.rpg.lexer.regular.dfa.DFA;
import foundation.rpg.lexer.regular.dfa.GNFATransformer;
import foundation.rpg.lexer.regular.thompson.GNFA;
import foundation.rpg.lexer.regular.thompson.ThompsonVisitor;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public class LexerGenerator {
    private final ThompsonVisitor visitor = new ThompsonVisitor();
    private final GNFATransformer transformer = new GNFATransformer();
    private final RegularGenerator generator = new RegularGenerator();

    public void generateLexer(String pkg, String name, List<TokenInfo> info, PrintWriter w, TypeMirror factoryType) {
        Map infoMap = info.stream().collect(Collectors.toMap(TokenInfo::getPattern, Function.identity()));
        GNFA gnfa = this.visitor.visit(info.stream().map(TokenInfo::getPattern).collect(Collectors.toList()));
        DFA dfa = this.transformer.transform(gnfa);
        Comparator<TokenInfo> comparator = Comparator.comparingInt(TokenInfo::getPriority);
        this.generator.generate(pkg, name, dfa, w, set -> set.stream().map(infoMap::get).max(comparator).orElseThrow(() -> new IllegalArgumentException("")).call, factoryType);
    }

    public static class TokenInfo {
        private final Object element;
        private final String call;
        private final Node pattern;
        private final int priority;

        public TokenInfo(Object element, String call, Node pattern, int priority) {
            this.element = element;
            this.call = call;
            this.pattern = pattern;
            this.priority = priority;
        }

        public Object getElement() {
            return this.element;
        }

        public Node getPattern() {
            return this.pattern;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

