/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

List4ListOfNode1: {
	Chain -> List4ListOfNode • [End, Pipe]
	List4ListOfNode -> List4ListOfNode • Node [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Star [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Plus [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Character [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Character [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Bs [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Dot [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Star [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs LBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Dot [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Up [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr List4ListOfItem RBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr Up List4ListOfItem RBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateList4ListOfNode1 extends StackState<java.util.List<foundation.rpg.lexer.regular.ast.Node>, State> {

// NoStack:
// Stack:
    public StateList4ListOfNode1(foundation.rpg.lexer.regular.RegularExpressionFactory factory, java.util.List<foundation.rpg.lexer.regular.ast.Node> node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
    @Override
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        
		State stack1 = this.getPrev();
        return stack1.visitChain(getFactory().is1(this.getNode())).visitEnd(symbol);
    }

    @Override
    public State visitPipe(foundation.rpg.common.symbols.Pipe symbol) throws UnexpectedInputException {
        
		State stack1 = this.getPrev();
        return stack1.visitChain(getFactory().is1(this.getNode())).visitPipe(symbol);
    }


// Shift:
    @Override
    public State visitNode(foundation.rpg.lexer.regular.ast.Node symbol) {
        return new StateNode2(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar1(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter1(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs1(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot1(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp1(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr1(getFactory(), symbol, this);
    }


// Accept:
}
