/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

LPar3: {
	Node -> LPar • Pattern RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Plus [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Bs [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs LBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Up [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateLPar3 extends StackState<foundation.rpg.common.symbols.LPar, State> {

// NoStack:
// Stack:
    public StateLPar3(foundation.rpg.lexer.regular.RegularExpressionFactory factory, foundation.rpg.common.symbols.LPar node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
    @Override
    public State visitRPar(foundation.rpg.common.symbols.RPar symbol) throws UnexpectedInputException {
        
        return this.visitPattern(getFactory().is()).visitRPar(symbol);
    }


// Shift:
    @Override
    public State visitPattern(foundation.rpg.lexer.regular.ast.Pattern symbol) {
        return new StatePattern3(getFactory(), symbol, this);
    }

    @Override
    public State visitListOfChain(java.util.List<foundation.rpg.lexer.regular.ast.Chain> symbol) {
        return new StateListOfChain2(getFactory(), symbol, this);
    }

    @Override
    public State visitChain(foundation.rpg.lexer.regular.ast.Chain symbol) {
        return new StateChain2(getFactory(), symbol, this);
    }

    @Override
    public State visitList4ListOfNode(java.util.List<foundation.rpg.lexer.regular.ast.Node> symbol) {
        return new StateList4ListOfNode2(getFactory(), symbol, this);
    }

    @Override
    public State visitNode(foundation.rpg.lexer.regular.ast.Node symbol) {
        return new StateNode3(getFactory(), symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) {
        return new StateLPar3(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter3(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs3(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot3(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp3(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr3(getFactory(), symbol, this);
    }


// Accept:
}
