/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

LBr3: {
	Node -> LBr • List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> LBr • Up List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateLBr3 extends StackState<foundation.rpg.common.symbols.LBr, State> {

// NoStack:
// Stack:
    public StateLBr3(foundation.rpg.lexer.regular.RegularExpressionFactory factory, foundation.rpg.common.symbols.LBr node, State prev) {
        super(factory, node, prev);
    }


// Reduce:
// Shift:
    @Override
    public State visitList4ListOfItem(java.util.List<foundation.rpg.lexer.regular.ast.Item> symbol) {
        return new StateList4ListOfItem2(getFactory(), symbol, this);
    }

    @Override
    public State visitUp(foundation.rpg.common.symbols.Up symbol) {
        return new StateUp8(getFactory(), symbol, this);
    }

    @Override
    public State visitItem(foundation.rpg.lexer.regular.ast.Item symbol) {
        return new StateItem1(getFactory(), symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter5(getFactory(), symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.symbols.Dot symbol) {
        return new StateDot5(getFactory(), symbol, this);
    }

    @Override
    public State visitStar(foundation.rpg.common.symbols.Star symbol) {
        return new StateStar3(getFactory(), symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) {
        return new StateLBr5(getFactory(), symbol, this);
    }

    @Override
    public State visitPipe(foundation.rpg.common.symbols.Pipe symbol) {
        return new StatePipe2(getFactory(), symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.symbols.Bs symbol) {
        return new StateBs5(getFactory(), symbol, this);
    }


// Accept:
}
