/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

N = [Start, Pattern, ListOfChain, Chain, List4ListOfNode, Node, List4ListOfItem, Item]
T = [End, Pipe, LPar, RPar, Star, Plus, Character, Bs, Dot, LBr, Up, RBr, Minus]
S = Start
R = {
	Start -> Pattern,End
	Pattern -> 
	Pattern -> ListOfChain
	ListOfChain -> Chain
	ListOfChain -> ListOfChain,Pipe,Chain
	Chain -> List4ListOfNode
	List4ListOfNode -> Node
	List4ListOfNode -> List4ListOfNode,Node
	Node -> LPar,Pattern,RPar
	Node -> Node,Star
	Node -> Node,Plus
	Node -> Character
	Node -> Bs,Character
	Node -> Bs,Bs
	Node -> Bs,Dot
	Node -> Bs,Star
	Node -> Bs,LBr
	Node -> Dot
	Node -> Up
	Node -> LBr,List4ListOfItem,RBr
	List4ListOfItem -> Item
	List4ListOfItem -> List4ListOfItem,Item
	Node -> LBr,Up,List4ListOfItem,RBr
	Item -> Character
	Item -> Dot
	Item -> Star
	Item -> LBr
	Item -> Pipe
	Item -> Bs,Bs
	Item -> Bs,RBr
	Item -> Character,Minus,Character
}

1: {
	Start -> • Pattern End []
	Pattern -> • [End]
	Pattern -> • ListOfChain [End]
	ListOfChain -> • Chain [End, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [End, Pipe]
	Chain -> • List4ListOfNode [End, Pipe]
	List4ListOfNode -> • Node [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Star [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Plus [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Character [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Character [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Bs [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Dot [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Star [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs LBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Dot [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Up [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Pattern1: {
	Start -> Pattern • End []
}
ListOfChain1: {
	Pattern -> ListOfChain • [End]
	ListOfChain -> ListOfChain • Pipe Chain [End, Pipe]
}
Chain1: {
	ListOfChain -> Chain • [End, Pipe]
}
List4ListOfNode1: {
	Chain -> List4ListOfNode • [End, Pipe]
	List4ListOfNode -> List4ListOfNode • Node [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Star [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Plus [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Character [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Character [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Bs [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Dot [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Star [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs LBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Dot [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Up [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr List4ListOfItem RBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr Up List4ListOfItem RBr [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
}
Node1: {
	List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Star [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Plus [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LPar1: {
	Node -> LPar • Pattern RPar [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Plus [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Bs [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs LBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Up [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Character1: {
	Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Bs1: {
	Node -> Bs • Character [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Bs [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Dot [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Star [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • LBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Dot1: {
	Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Up1: {
	Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LBr1: {
	Node -> LBr • List4ListOfItem RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> LBr • Up List4ListOfItem RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
End1: {
	Start -> Pattern End • []
}
Pipe1: {
	ListOfChain -> ListOfChain Pipe • Chain [End, Pipe]
	Chain -> • List4ListOfNode [End, Pipe]
	List4ListOfNode -> • Node [End, Pipe, LPar, Character, Bs, Dot, Up, LBr]
	List4ListOfNode -> • List4ListOfNode Node [End, Pipe, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LPar Pattern RPar [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Node Star [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Node Plus [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Character [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Character [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Bs [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Dot [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Star [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs LBr [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Dot [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Up [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LBr List4ListOfItem RBr [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LBr Up List4ListOfItem RBr [End, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
}
Node2: {
	List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Star [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> Node • Plus [End, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
}
Star1: {
	Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Plus1: {
	Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Pattern2: {
	Node -> LPar Pattern • RPar [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
ListOfChain2: {
	Pattern -> ListOfChain • [RPar]
	ListOfChain -> ListOfChain • Pipe Chain [RPar, Pipe]
}
Chain2: {
	ListOfChain -> Chain • [RPar, Pipe]
}
List4ListOfNode2: {
	Chain -> List4ListOfNode • [RPar, Pipe]
	List4ListOfNode -> List4ListOfNode • Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Star [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Node Plus [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Character [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Character [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Bs [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Dot [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs Star [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Bs LBr [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Dot [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • Up [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr List4ListOfItem RBr [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> • LBr Up List4ListOfItem RBr [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
}
Node3: {
	List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Plus [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LPar3: {
	Node -> LPar • Pattern RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Node Plus [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Bs [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Bs LBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • Up [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Character3: {
	Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Bs3: {
	Node -> Bs • Character [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Bs [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Dot [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • Star [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Bs • LBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Dot3: {
	Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Up3: {
	Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LBr3: {
	Node -> LBr • List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> LBr • Up List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Character4: {
	Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Bs4: {
	Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Dot4: {
	Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Star2: {
	Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LBr4: {
	Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
List4ListOfItem1: {
	Node -> LBr List4ListOfItem • RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Up4: {
	Node -> LBr Up • List4ListOfItem RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Item1: {
	List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Character5: {
	Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> Character • Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Dot5: {
	Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Star3: {
	Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
LBr5: {
	Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Pipe2: {
	Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Bs5: {
	Item -> Bs • Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> Bs • RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Chain3: {
	ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
}
RPar1: {
	Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Pipe3: {
	ListOfChain -> ListOfChain Pipe • Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, Pipe, LPar, Character, Bs, Dot, Up, LBr]
	List4ListOfNode -> • List4ListOfNode Node [RPar, Pipe, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LPar Pattern RPar [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Node Star [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Node Plus [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Character [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Character [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Bs [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Dot [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs Star [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Bs LBr [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Dot [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • Up [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LBr List4ListOfItem RBr [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Pipe, Star, Plus, LPar, Character, Bs, Dot, Up, LBr]
}
Node5: {
	List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	Node -> Node • Star [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
	Node -> Node • Plus [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe, Star, Plus]
}
Star5: {
	Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Plus3: {
	Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Pattern3: {
	Node -> LPar Pattern • RPar [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Character9: {
	Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Bs9: {
	Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Dot9: {
	Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Star6: {
	Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
LBr9: {
	Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
List4ListOfItem2: {
	Node -> LBr List4ListOfItem • RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Up8: {
	Node -> LBr Up • List4ListOfItem RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr1: {
	Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Item3: {
	List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
List4ListOfItem3: {
	Node -> LBr Up List4ListOfItem • RBr [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Minus1: {
	Item -> Character Minus • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Bs13: {
	Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr2: {
	Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
Chain5: {
	ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
}
RPar2: {
	Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
RBr3: {
	Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
List4ListOfItem4: {
	Node -> LBr Up List4ListOfItem • RBr [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Dot [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Star [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • LBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Pipe [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs Bs [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Bs RBr [RBr, Character, Dot, Star, LBr, Pipe, Bs]
	Item -> • Character Minus Character [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr4: {
	Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}
Character17: {
	Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
}
RBr5: {
	Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
}

1: End -> REDUCE: Pattern -> • [End]
1: Pattern -> GOTO: Pattern1
1: ListOfChain -> GOTO: ListOfChain1
1: Chain -> GOTO: Chain1
1: List4ListOfNode -> GOTO: List4ListOfNode1
1: Node -> GOTO: Node1
1: LPar -> GOTO: LPar1
1: Character -> GOTO: Character1
1: Bs -> GOTO: Bs1
1: Dot -> GOTO: Dot1
1: Up -> GOTO: Up1
1: LBr -> GOTO: LBr1
Pattern1: End -> GOTO: End1
ListOfChain1: End -> REDUCE: Pattern -> ListOfChain • [End]
ListOfChain1: Pipe -> GOTO: Pipe1
Chain1: End -> REDUCE: ListOfChain -> Chain • [End, Pipe]
Chain1: Pipe -> REDUCE: ListOfChain -> Chain • [End, Pipe]
List4ListOfNode1: End -> REDUCE: Chain -> List4ListOfNode • [End, Pipe]
List4ListOfNode1: Pipe -> REDUCE: Chain -> List4ListOfNode • [End, Pipe]
List4ListOfNode1: Node -> GOTO: Node2
List4ListOfNode1: LPar -> GOTO: LPar1
List4ListOfNode1: Character -> GOTO: Character1
List4ListOfNode1: Bs -> GOTO: Bs1
List4ListOfNode1: Dot -> GOTO: Dot1
List4ListOfNode1: Up -> GOTO: Up1
List4ListOfNode1: LBr -> GOTO: LBr1
Node1: End -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: LPar -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Character -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Bs -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Dot -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Up -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: LBr -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Pipe -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node1: Star -> GOTO: Star1
Node1: Plus -> GOTO: Plus1
LPar1: RPar -> REDUCE: Pattern -> • [RPar]
LPar1: Pattern -> GOTO: Pattern2
LPar1: ListOfChain -> GOTO: ListOfChain2
LPar1: Chain -> GOTO: Chain2
LPar1: List4ListOfNode -> GOTO: List4ListOfNode2
LPar1: Node -> GOTO: Node3
LPar1: LPar -> GOTO: LPar3
LPar1: Character -> GOTO: Character3
LPar1: Bs -> GOTO: Bs3
LPar1: Dot -> GOTO: Dot3
LPar1: Up -> GOTO: Up3
LPar1: LBr -> GOTO: LBr3
Character1: End -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Star -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Plus -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: LPar -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Character -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Bs -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Dot -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Up -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: LBr -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character1: Pipe -> REDUCE: Node -> Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs1: Character -> GOTO: Character4
Bs1: Bs -> GOTO: Bs4
Bs1: Dot -> GOTO: Dot4
Bs1: Star -> GOTO: Star2
Bs1: LBr -> GOTO: LBr4
Dot1: End -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Star -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Plus -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: LPar -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Character -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Bs -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Dot -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Up -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: LBr -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot1: Pipe -> REDUCE: Node -> Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: End -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Star -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Plus -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: LPar -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Character -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Bs -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Dot -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Up -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: LBr -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up1: Pipe -> REDUCE: Node -> Up • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr1: List4ListOfItem -> GOTO: List4ListOfItem1
LBr1: Up -> GOTO: Up4
LBr1: Item -> GOTO: Item1
LBr1: Character -> GOTO: Character5
LBr1: Dot -> GOTO: Dot5
LBr1: Star -> GOTO: Star3
LBr1: LBr -> GOTO: LBr5
LBr1: Pipe -> GOTO: Pipe2
LBr1: Bs -> GOTO: Bs5
End1:  -> ACCEPT: Start -> Pattern End • []
Pipe1: Chain -> GOTO: Chain3
Pipe1: List4ListOfNode -> GOTO: List4ListOfNode1
Pipe1: Node -> GOTO: Node1
Pipe1: LPar -> GOTO: LPar1
Pipe1: Character -> GOTO: Character1
Pipe1: Bs -> GOTO: Bs1
Pipe1: Dot -> GOTO: Dot1
Pipe1: Up -> GOTO: Up1
Pipe1: LBr -> GOTO: LBr1
Node2: End -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: LPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Character -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Bs -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Dot -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Up -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: LBr -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Pipe -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node2: Star -> GOTO: Star1
Node2: Plus -> GOTO: Plus1
Star1: End -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Star -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Plus -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: LPar -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Character -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Bs -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Dot -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Up -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: LBr -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star1: Pipe -> REDUCE: Node -> Node Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: End -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Star -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Plus -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: LPar -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Character -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Bs -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Dot -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Up -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: LBr -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus1: Pipe -> REDUCE: Node -> Node Plus • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Pattern2: RPar -> GOTO: RPar1
ListOfChain2: RPar -> REDUCE: Pattern -> ListOfChain • [RPar]
ListOfChain2: Pipe -> GOTO: Pipe3
Chain2: RPar -> REDUCE: ListOfChain -> Chain • [RPar, Pipe]
Chain2: Pipe -> REDUCE: ListOfChain -> Chain • [RPar, Pipe]
List4ListOfNode2: RPar -> REDUCE: Chain -> List4ListOfNode • [RPar, Pipe]
List4ListOfNode2: Pipe -> REDUCE: Chain -> List4ListOfNode • [RPar, Pipe]
List4ListOfNode2: Node -> GOTO: Node5
List4ListOfNode2: LPar -> GOTO: LPar3
List4ListOfNode2: Character -> GOTO: Character3
List4ListOfNode2: Bs -> GOTO: Bs3
List4ListOfNode2: Dot -> GOTO: Dot3
List4ListOfNode2: Up -> GOTO: Up3
List4ListOfNode2: LBr -> GOTO: LBr3
Node3: RPar -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: LPar -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Character -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Bs -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Dot -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Up -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: LBr -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Pipe -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node3: Star -> GOTO: Star5
Node3: Plus -> GOTO: Plus3
LPar3: RPar -> REDUCE: Pattern -> • [RPar]
LPar3: Pattern -> GOTO: Pattern3
LPar3: ListOfChain -> GOTO: ListOfChain2
LPar3: Chain -> GOTO: Chain2
LPar3: List4ListOfNode -> GOTO: List4ListOfNode2
LPar3: Node -> GOTO: Node3
LPar3: LPar -> GOTO: LPar3
LPar3: Character -> GOTO: Character3
LPar3: Bs -> GOTO: Bs3
LPar3: Dot -> GOTO: Dot3
LPar3: Up -> GOTO: Up3
LPar3: LBr -> GOTO: LBr3
Character3: RPar -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Star -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Plus -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: LPar -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Character -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Bs -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Dot -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Up -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: LBr -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character3: Pipe -> REDUCE: Node -> Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs3: Character -> GOTO: Character9
Bs3: Bs -> GOTO: Bs9
Bs3: Dot -> GOTO: Dot9
Bs3: Star -> GOTO: Star6
Bs3: LBr -> GOTO: LBr9
Dot3: RPar -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Star -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Plus -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: LPar -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Character -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Bs -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Dot -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Up -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: LBr -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot3: Pipe -> REDUCE: Node -> Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: RPar -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Star -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Plus -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: LPar -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Character -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Bs -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Dot -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Up -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: LBr -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Up3: Pipe -> REDUCE: Node -> Up • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr3: List4ListOfItem -> GOTO: List4ListOfItem2
LBr3: Up -> GOTO: Up8
LBr3: Item -> GOTO: Item1
LBr3: Character -> GOTO: Character5
LBr3: Dot -> GOTO: Dot5
LBr3: Star -> GOTO: Star3
LBr3: LBr -> GOTO: LBr5
LBr3: Pipe -> GOTO: Pipe2
LBr3: Bs -> GOTO: Bs5
Character4: End -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Star -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Plus -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: LPar -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Character -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Bs -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Dot -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Up -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: LBr -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character4: Pipe -> REDUCE: Node -> Bs Character • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: End -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Star -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Plus -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: LPar -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Character -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Bs -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Dot -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Up -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: LBr -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs4: Pipe -> REDUCE: Node -> Bs Bs • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: End -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Star -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Plus -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: LPar -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Character -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Bs -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Dot -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Up -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: LBr -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot4: Pipe -> REDUCE: Node -> Bs Dot • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: End -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Star -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Plus -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: LPar -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Character -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Bs -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Dot -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Up -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: LBr -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star2: Pipe -> REDUCE: Node -> Bs Star • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: End -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Star -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Plus -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: LPar -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Character -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Bs -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Dot -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Up -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: LBr -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr4: Pipe -> REDUCE: Node -> Bs LBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
List4ListOfItem1: RBr -> GOTO: RBr1
List4ListOfItem1: Item -> GOTO: Item3
List4ListOfItem1: Character -> GOTO: Character5
List4ListOfItem1: Dot -> GOTO: Dot5
List4ListOfItem1: Star -> GOTO: Star3
List4ListOfItem1: LBr -> GOTO: LBr5
List4ListOfItem1: Pipe -> GOTO: Pipe2
List4ListOfItem1: Bs -> GOTO: Bs5
Up4: List4ListOfItem -> GOTO: List4ListOfItem3
Up4: Item -> GOTO: Item1
Up4: Character -> GOTO: Character5
Up4: Dot -> GOTO: Dot5
Up4: Star -> GOTO: Star3
Up4: LBr -> GOTO: LBr5
Up4: Pipe -> GOTO: Pipe2
Up4: Bs -> GOTO: Bs5
Item1: RBr -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: Character -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: Dot -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: Star -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: LBr -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: Pipe -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item1: Bs -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: RBr -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Character -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Dot -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Star -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: LBr -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Pipe -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Bs -> REDUCE: Item -> Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character5: Minus -> GOTO: Minus1
Dot5: RBr -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Character -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Dot -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Star -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: LBr -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Pipe -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Dot5: Bs -> REDUCE: Item -> Dot • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: RBr -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Character -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Dot -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Star -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: LBr -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Pipe -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Star3: Bs -> REDUCE: Item -> Star • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: RBr -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Character -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Dot -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Star -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: LBr -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Pipe -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
LBr5: Bs -> REDUCE: Item -> LBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: RBr -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Character -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Dot -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Star -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: LBr -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Pipe -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Pipe2: Bs -> REDUCE: Item -> Pipe • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs5: Bs -> GOTO: Bs13
Bs5: RBr -> GOTO: RBr2
Chain3: End -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
Chain3: Pipe -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
RPar1: End -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Star -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Plus -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: LPar -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Character -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Bs -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Dot -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Up -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: LBr -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar1: Pipe -> REDUCE: Node -> LPar Pattern RPar • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Pipe3: Chain -> GOTO: Chain5
Pipe3: List4ListOfNode -> GOTO: List4ListOfNode2
Pipe3: Node -> GOTO: Node3
Pipe3: LPar -> GOTO: LPar3
Pipe3: Character -> GOTO: Character3
Pipe3: Bs -> GOTO: Bs3
Pipe3: Dot -> GOTO: Dot3
Pipe3: Up -> GOTO: Up3
Pipe3: LBr -> GOTO: LBr3
Node5: RPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: LPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Character -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Bs -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Dot -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Up -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: LBr -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Pipe -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Node5: Star -> GOTO: Star5
Node5: Plus -> GOTO: Plus3
Star5: RPar -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Star -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Plus -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: LPar -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Character -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Bs -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Dot -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Up -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: LBr -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star5: Pipe -> REDUCE: Node -> Node Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: RPar -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Star -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Plus -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: LPar -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Character -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Bs -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Dot -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Up -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: LBr -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Plus3: Pipe -> REDUCE: Node -> Node Plus • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Pattern3: RPar -> GOTO: RPar2
Character9: RPar -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Star -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Plus -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: LPar -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Character -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Bs -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Dot -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Up -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: LBr -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character9: Pipe -> REDUCE: Node -> Bs Character • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: RPar -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Star -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Plus -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: LPar -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Character -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Bs -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Dot -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Up -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: LBr -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Bs9: Pipe -> REDUCE: Node -> Bs Bs • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: RPar -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Star -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Plus -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: LPar -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Character -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Bs -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Dot -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Up -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: LBr -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Dot9: Pipe -> REDUCE: Node -> Bs Dot • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: RPar -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Star -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Plus -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: LPar -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Character -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Bs -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Dot -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Up -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: LBr -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Star6: Pipe -> REDUCE: Node -> Bs Star • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: RPar -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Star -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Plus -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: LPar -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Character -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Bs -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Dot -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Up -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: LBr -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
LBr9: Pipe -> REDUCE: Node -> Bs LBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
List4ListOfItem2: RBr -> GOTO: RBr3
List4ListOfItem2: Item -> GOTO: Item3
List4ListOfItem2: Character -> GOTO: Character5
List4ListOfItem2: Dot -> GOTO: Dot5
List4ListOfItem2: Star -> GOTO: Star3
List4ListOfItem2: LBr -> GOTO: LBr5
List4ListOfItem2: Pipe -> GOTO: Pipe2
List4ListOfItem2: Bs -> GOTO: Bs5
Up8: List4ListOfItem -> GOTO: List4ListOfItem4
Up8: Item -> GOTO: Item1
Up8: Character -> GOTO: Character5
Up8: Dot -> GOTO: Dot5
Up8: Star -> GOTO: Star3
Up8: LBr -> GOTO: LBr5
Up8: Pipe -> GOTO: Pipe2
Up8: Bs -> GOTO: Bs5
RBr1: End -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Star -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Plus -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: LPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Character -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Bs -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Dot -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Up -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: LBr -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr1: Pipe -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Item3: RBr -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: Character -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: Dot -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: Star -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: LBr -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: Pipe -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Item3: Bs -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
List4ListOfItem3: RBr -> GOTO: RBr4
List4ListOfItem3: Item -> GOTO: Item3
List4ListOfItem3: Character -> GOTO: Character5
List4ListOfItem3: Dot -> GOTO: Dot5
List4ListOfItem3: Star -> GOTO: Star3
List4ListOfItem3: LBr -> GOTO: LBr5
List4ListOfItem3: Pipe -> GOTO: Pipe2
List4ListOfItem3: Bs -> GOTO: Bs5
Minus1: Character -> GOTO: Character17
Bs13: RBr -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Character -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Dot -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Star -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: LBr -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Pipe -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Bs13: Bs -> REDUCE: Item -> Bs Bs • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: RBr -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Character -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Dot -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Star -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: LBr -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Pipe -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr2: Bs -> REDUCE: Item -> Bs RBr • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Chain5: RPar -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
Chain5: Pipe -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
RPar2: RPar -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Star -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Plus -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: LPar -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Character -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Bs -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Dot -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Up -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: LBr -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RPar2: Pipe -> REDUCE: Node -> LPar Pattern RPar • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: RPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Star -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Plus -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: LPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Character -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Bs -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Dot -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Up -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: LBr -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr3: Pipe -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
List4ListOfItem4: RBr -> GOTO: RBr5
List4ListOfItem4: Item -> GOTO: Item3
List4ListOfItem4: Character -> GOTO: Character5
List4ListOfItem4: Dot -> GOTO: Dot5
List4ListOfItem4: Star -> GOTO: Star3
List4ListOfItem4: LBr -> GOTO: LBr5
List4ListOfItem4: Pipe -> GOTO: Pipe2
List4ListOfItem4: Bs -> GOTO: Bs5
RBr4: End -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Star -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Plus -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: LPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Character -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Bs -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Dot -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Up -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: LBr -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr4: Pipe -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
Character17: RBr -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Character -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Dot -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Star -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: LBr -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Pipe -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
Character17: Bs -> REDUCE: Item -> Character Minus Character • [RBr, Character, Dot, Star, LBr, Pipe, Bs]
RBr5: RPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Star -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Plus -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: LPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Character -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Bs -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Dot -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Up -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: LBr -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]
RBr5: Pipe -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Star, Plus, LPar, Character, Bs, Dot, Up, LBr, Pipe]

*/

import foundation.rpg.parser.UnexpectedInputException;
import foundation.rpg.parser.StateBase;

// Generated visitor pattern based state for grammar parser.
public class State extends StateBase<foundation.rpg.lexer.regular.ast.Pattern> {
    private final foundation.rpg.lexer.regular.RegularExpressionFactory factory;

    public State(foundation.rpg.lexer.regular.RegularExpressionFactory factory) {
        this.factory = factory;
    }

    public foundation.rpg.lexer.regular.RegularExpressionFactory getFactory() {
        return factory;
    }

    // Ignored:
// Symbols:
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPipe(foundation.rpg.common.symbols.Pipe symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLPar(foundation.rpg.common.symbols.LPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRPar(foundation.rpg.common.symbols.RPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitStar(foundation.rpg.common.symbols.Star symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPlus(foundation.rpg.common.symbols.Plus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitCharacter(java.lang.Character symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitBs(foundation.rpg.common.symbols.Bs symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitDot(foundation.rpg.common.symbols.Dot symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLBr(foundation.rpg.common.symbols.LBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitUp(foundation.rpg.common.symbols.Up symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRBr(foundation.rpg.common.symbols.RBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitMinus(foundation.rpg.common.symbols.Minus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPattern(foundation.rpg.lexer.regular.ast.Pattern symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitListOfChain(java.util.List<foundation.rpg.lexer.regular.ast.Chain> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitChain(foundation.rpg.lexer.regular.ast.Chain symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList4ListOfNode(java.util.List<foundation.rpg.lexer.regular.ast.Node> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitNode(foundation.rpg.lexer.regular.ast.Node symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList4ListOfItem(java.util.List<foundation.rpg.lexer.regular.ast.Item> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitItem(foundation.rpg.lexer.regular.ast.Item symbol) throws UnexpectedInputException {
        return error(symbol);
    }


}
