/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

Up2: {
	Node -> LBr Up • List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Bs, Dot]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateUp2 extends StackState<foundation.rpg.common.Up, StackState<foundation.rpg.common.LBr, ? extends State>> {
// Stack:
    public StateUp2(foundation.rpg.common.Up node, StackState<foundation.rpg.common.LBr, ? extends State> prev) {
        super(node, prev);
    }


// Reduce:
// Shift:
    @Override
    public State visitList4ListOfItem(java.util.List<foundation.rpg.lexer.regular.ast.Item> symbol) {
        return new StateList4ListOfItem4(symbol, this);
    }

    @Override
    public State visitItem(foundation.rpg.lexer.regular.ast.Item symbol) {
        return new StateItem1(symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter5(symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.Bs symbol) {
        return new StateBs5(symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.Dot symbol) {
        return new StateDot5(symbol, this);
    }


// Accept:
}
