/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

LPar1: {
	Node -> LPar • Pattern RPar [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Times [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Plus [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Bs [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;

// Generated visitor pattern based state for grammar parser.
public class StateLPar1 extends StackState<foundation.rpg.common.LPar, State> {
// Stack:
    public StateLPar1(foundation.rpg.common.LPar node, State prev) {
        super(node, prev);
    }


// Reduce:
    @Override
    public State visitRPar(foundation.rpg.common.RPar symbol) throws UnexpectedInputException {
        
        return this.visitPattern(foundation.rpg.lexer.regular.RegularExpressionFactory.is()).visitRPar(symbol);
    }


// Shift:
    @Override
    public State visitPattern(foundation.rpg.lexer.regular.ast.Pattern symbol) {
        return new StatePattern2(symbol, this);
    }

    @Override
    public State visitListOfChain(java.util.List<foundation.rpg.lexer.regular.ast.Chain> symbol) {
        return new StateListOfChain2(symbol, this);
    }

    @Override
    public State visitChain(foundation.rpg.lexer.regular.ast.Chain symbol) {
        return new StateChain2(symbol, this);
    }

    @Override
    public State visitList4ListOfNode(java.util.List<foundation.rpg.lexer.regular.ast.Node> symbol) {
        return new StateList4ListOfNode2(symbol, this);
    }

    @Override
    public State visitNode(foundation.rpg.lexer.regular.ast.Node symbol) {
        return new StateNode3(symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.LPar symbol) {
        return new StateLPar3(symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter3(symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.Bs symbol) {
        return new StateBs3(symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.Dot symbol) {
        return new StateDot3(symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.LBr symbol) {
        return new StateLBr3(symbol, this);
    }


// Accept:
}
