/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.regular;

/*

N = [Start, Pattern, ListOfChain, Chain, List4ListOfNode, Node, List4ListOfItem, Item]
T = [End, Pipe, LPar, RPar, Times, Plus, Character, Bs, Dot, LBr, RBr, Up, Minus]
S = Start
R = {
	Start -> Pattern,End
	Pattern -> 
	Pattern -> ListOfChain
	ListOfChain -> Chain
	ListOfChain -> ListOfChain,Pipe,Chain
	Chain -> List4ListOfNode
	List4ListOfNode -> Node
	List4ListOfNode -> List4ListOfNode,Node
	Node -> LPar,Pattern,RPar
	Node -> Node,Times
	Node -> Node,Plus
	Node -> Character
	Node -> Bs,Character
	Node -> Bs,Bs
	Node -> Bs,Dot
	Node -> Dot
	Node -> LBr,List4ListOfItem,RBr
	List4ListOfItem -> Item
	List4ListOfItem -> List4ListOfItem,Item
	Node -> LBr,Up,List4ListOfItem,RBr
	Item -> Character
	Item -> Bs
	Item -> Dot
	Item -> Character,Minus,Character
}

1: {
	Start -> • Pattern End []
	Pattern -> • [End]
	Pattern -> • ListOfChain [End]
	ListOfChain -> • Chain [End, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [End, Pipe]
	Chain -> • List4ListOfNode [End, Pipe]
	List4ListOfNode -> • Node [End, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [End, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Times [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Plus [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Character [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Character [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Bs [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Dot [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Dot [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Pattern1: {
	Start -> Pattern • End []
}
ListOfChain1: {
	Pattern -> ListOfChain • [End]
	ListOfChain -> ListOfChain • Pipe Chain [End, Pipe]
}
Chain1: {
	ListOfChain -> Chain • [End, Pipe]
}
List4ListOfNode1: {
	Chain -> List4ListOfNode • [End, Pipe]
	List4ListOfNode -> List4ListOfNode • Node [End, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Node Times [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Node Plus [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Character [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Character [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Bs [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Dot [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Dot [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • LBr List4ListOfItem RBr [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • LBr Up List4ListOfItem RBr [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
}
Node1: {
	List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Times [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Plus [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
LPar1: {
	Node -> LPar • Pattern RPar [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Times [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Plus [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Bs [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Character1: {
	Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Bs1: {
	Node -> Bs • Character [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Bs • Bs [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Bs • Dot [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Dot1: {
	Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
LBr1: {
	Node -> LBr • List4ListOfItem RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> LBr • Up List4ListOfItem RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Bs, Dot]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
End1: {
	Start -> Pattern End • []
}
Pipe1: {
	ListOfChain -> ListOfChain Pipe • Chain [End, Pipe]
	Chain -> • List4ListOfNode [End, Pipe]
	List4ListOfNode -> • Node [End, Pipe, LPar, Character, Bs, Dot, LBr]
	List4ListOfNode -> • List4ListOfNode Node [End, Pipe, LPar, Character, Bs, Dot, LBr]
	Node -> • LPar Pattern RPar [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Node Times [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Node Plus [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Character [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Character [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Bs [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Dot [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Dot [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • LBr List4ListOfItem RBr [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • LBr Up List4ListOfItem RBr [End, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
}
Node2: {
	List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Times [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> Node • Plus [End, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
}
Times1: {
	Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Plus1: {
	Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Pattern2: {
	Node -> LPar Pattern • RPar [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
ListOfChain2: {
	Pattern -> ListOfChain • [RPar]
	ListOfChain -> ListOfChain • Pipe Chain [RPar, Pipe]
}
Chain2: {
	ListOfChain -> Chain • [RPar, Pipe]
}
List4ListOfNode2: {
	Chain -> List4ListOfNode • [RPar, Pipe]
	List4ListOfNode -> List4ListOfNode • Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Node Times [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Node Plus [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Character [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Character [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Bs [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Bs Dot [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • Dot [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • LBr List4ListOfItem RBr [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> • LBr Up List4ListOfItem RBr [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
}
Node3: {
	List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Times [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Plus [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
LPar3: {
	Node -> LPar • Pattern RPar [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Pattern -> • [RPar]
	Pattern -> • ListOfChain [RPar]
	ListOfChain -> • Chain [RPar, Pipe]
	ListOfChain -> • ListOfChain Pipe Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfNode -> • List4ListOfNode Node [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LPar Pattern RPar [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Times [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Node Plus [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Bs [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Bs Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Character3: {
	Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Bs3: {
	Node -> Bs • Character [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Bs • Bs [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Bs • Dot [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Dot3: {
	Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
LBr3: {
	Node -> LBr • List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> LBr • Up List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Bs, Dot]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
Character4: {
	Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Bs4: {
	Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Dot4: {
	Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
List4ListOfItem1: {
	Node -> LBr List4ListOfItem • RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
Up1: {
	Node -> LBr Up • List4ListOfItem RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Bs, Dot]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
Item1: {
	List4ListOfItem -> Item • [RBr, Character, Bs, Dot]
}
Character5: {
	Item -> Character • [RBr, Character, Bs, Dot]
	Item -> Character • Minus Character [RBr, Character, Bs, Dot]
}
Bs5: {
	Item -> Bs • [RBr, Character, Bs, Dot]
}
Dot5: {
	Item -> Dot • [RBr, Character, Bs, Dot]
}
Chain3: {
	ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
}
RPar1: {
	Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Pipe2: {
	ListOfChain -> ListOfChain Pipe • Chain [RPar, Pipe]
	Chain -> • List4ListOfNode [RPar, Pipe]
	List4ListOfNode -> • Node [RPar, Pipe, LPar, Character, Bs, Dot, LBr]
	List4ListOfNode -> • List4ListOfNode Node [RPar, Pipe, LPar, Character, Bs, Dot, LBr]
	Node -> • LPar Pattern RPar [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Node Times [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Node Plus [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Character [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Character [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Bs [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Bs Dot [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • Dot [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • LBr List4ListOfItem RBr [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
	Node -> • LBr Up List4ListOfItem RBr [RPar, Pipe, Times, Plus, LPar, Character, Bs, Dot, LBr]
}
Node5: {
	List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
	Node -> Node • Times [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
	Node -> Node • Plus [RPar, LPar, Character, Bs, Dot, LBr, Pipe, Times, Plus]
}
Times3: {
	Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Plus3: {
	Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Pattern3: {
	Node -> LPar Pattern • RPar [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Character9: {
	Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Bs9: {
	Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Dot9: {
	Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
List4ListOfItem2: {
	Node -> LBr List4ListOfItem • RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
Up2: {
	Node -> LBr Up • List4ListOfItem RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> • Item [RBr, Character, Bs, Dot]
	List4ListOfItem -> • List4ListOfItem Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
RBr1: {
	Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Item3: {
	List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Bs, Dot]
}
List4ListOfItem3: {
	Node -> LBr Up List4ListOfItem • RBr [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
Minus1: {
	Item -> Character Minus • Character [RBr, Character, Bs, Dot]
}
Chain5: {
	ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
}
RPar2: {
	Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
RBr2: {
	Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
List4ListOfItem4: {
	Node -> LBr Up List4ListOfItem • RBr [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
	List4ListOfItem -> List4ListOfItem • Item [RBr, Character, Bs, Dot]
	Item -> • Character [RBr, Character, Bs, Dot]
	Item -> • Bs [RBr, Character, Bs, Dot]
	Item -> • Dot [RBr, Character, Bs, Dot]
	Item -> • Character Minus Character [RBr, Character, Bs, Dot]
}
RBr3: {
	Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}
Character17: {
	Item -> Character Minus Character • [RBr, Character, Bs, Dot]
}
RBr4: {
	Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
}

1: End -> REDUCE: Pattern -> • [End]
1: Pattern -> GOTO: Pattern1
1: ListOfChain -> GOTO: ListOfChain1
1: Chain -> GOTO: Chain1
1: List4ListOfNode -> GOTO: List4ListOfNode1
1: Node -> GOTO: Node1
1: LPar -> GOTO: LPar1
1: Character -> GOTO: Character1
1: Bs -> GOTO: Bs1
1: Dot -> GOTO: Dot1
1: LBr -> GOTO: LBr1
Pattern1: End -> GOTO: End1
ListOfChain1: End -> REDUCE: Pattern -> ListOfChain • [End]
ListOfChain1: Pipe -> GOTO: Pipe1
Chain1: End -> REDUCE: ListOfChain -> Chain • [End, Pipe]
Chain1: Pipe -> REDUCE: ListOfChain -> Chain • [End, Pipe]
List4ListOfNode1: End -> REDUCE: Chain -> List4ListOfNode • [End, Pipe]
List4ListOfNode1: Pipe -> REDUCE: Chain -> List4ListOfNode • [End, Pipe]
List4ListOfNode1: Node -> GOTO: Node2
List4ListOfNode1: LPar -> GOTO: LPar1
List4ListOfNode1: Character -> GOTO: Character1
List4ListOfNode1: Bs -> GOTO: Bs1
List4ListOfNode1: Dot -> GOTO: Dot1
List4ListOfNode1: LBr -> GOTO: LBr1
Node1: End -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: LPar -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: Character -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: Bs -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: Dot -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: LBr -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: Pipe -> REDUCE: List4ListOfNode -> Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node1: Times -> GOTO: Times1
Node1: Plus -> GOTO: Plus1
LPar1: RPar -> REDUCE: Pattern -> • [RPar]
LPar1: Pattern -> GOTO: Pattern2
LPar1: ListOfChain -> GOTO: ListOfChain2
LPar1: Chain -> GOTO: Chain2
LPar1: List4ListOfNode -> GOTO: List4ListOfNode2
LPar1: Node -> GOTO: Node3
LPar1: LPar -> GOTO: LPar3
LPar1: Character -> GOTO: Character3
LPar1: Bs -> GOTO: Bs3
LPar1: Dot -> GOTO: Dot3
LPar1: LBr -> GOTO: LBr3
Character1: End -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Times -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Plus -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: LPar -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Character -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Bs -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Dot -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: LBr -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character1: Pipe -> REDUCE: Node -> Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs1: Character -> GOTO: Character4
Bs1: Bs -> GOTO: Bs4
Bs1: Dot -> GOTO: Dot4
Dot1: End -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Times -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Plus -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: LPar -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Character -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Bs -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Dot -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: LBr -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot1: Pipe -> REDUCE: Node -> Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
LBr1: List4ListOfItem -> GOTO: List4ListOfItem1
LBr1: Up -> GOTO: Up1
LBr1: Item -> GOTO: Item1
LBr1: Character -> GOTO: Character5
LBr1: Bs -> GOTO: Bs5
LBr1: Dot -> GOTO: Dot5
End1:  -> ACCEPT: Start -> Pattern End • []
Pipe1: Chain -> GOTO: Chain3
Pipe1: List4ListOfNode -> GOTO: List4ListOfNode1
Pipe1: Node -> GOTO: Node1
Pipe1: LPar -> GOTO: LPar1
Pipe1: Character -> GOTO: Character1
Pipe1: Bs -> GOTO: Bs1
Pipe1: Dot -> GOTO: Dot1
Pipe1: LBr -> GOTO: LBr1
Node2: End -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: LPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: Character -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: Bs -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: Dot -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: LBr -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: Pipe -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [End, LPar, Character, Bs, Dot, LBr, Pipe]
Node2: Times -> GOTO: Times1
Node2: Plus -> GOTO: Plus1
Times1: End -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Times -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Plus -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: LPar -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Character -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Bs -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Dot -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: LBr -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times1: Pipe -> REDUCE: Node -> Node Times • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: End -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Times -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Plus -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: LPar -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Character -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Bs -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Dot -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: LBr -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus1: Pipe -> REDUCE: Node -> Node Plus • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Pattern2: RPar -> GOTO: RPar1
ListOfChain2: RPar -> REDUCE: Pattern -> ListOfChain • [RPar]
ListOfChain2: Pipe -> GOTO: Pipe2
Chain2: RPar -> REDUCE: ListOfChain -> Chain • [RPar, Pipe]
Chain2: Pipe -> REDUCE: ListOfChain -> Chain • [RPar, Pipe]
List4ListOfNode2: RPar -> REDUCE: Chain -> List4ListOfNode • [RPar, Pipe]
List4ListOfNode2: Pipe -> REDUCE: Chain -> List4ListOfNode • [RPar, Pipe]
List4ListOfNode2: Node -> GOTO: Node5
List4ListOfNode2: LPar -> GOTO: LPar3
List4ListOfNode2: Character -> GOTO: Character3
List4ListOfNode2: Bs -> GOTO: Bs3
List4ListOfNode2: Dot -> GOTO: Dot3
List4ListOfNode2: LBr -> GOTO: LBr3
Node3: RPar -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: LPar -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: Character -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: Bs -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: Dot -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: LBr -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: Pipe -> REDUCE: List4ListOfNode -> Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node3: Times -> GOTO: Times3
Node3: Plus -> GOTO: Plus3
LPar3: RPar -> REDUCE: Pattern -> • [RPar]
LPar3: Pattern -> GOTO: Pattern3
LPar3: ListOfChain -> GOTO: ListOfChain2
LPar3: Chain -> GOTO: Chain2
LPar3: List4ListOfNode -> GOTO: List4ListOfNode2
LPar3: Node -> GOTO: Node3
LPar3: LPar -> GOTO: LPar3
LPar3: Character -> GOTO: Character3
LPar3: Bs -> GOTO: Bs3
LPar3: Dot -> GOTO: Dot3
LPar3: LBr -> GOTO: LBr3
Character3: RPar -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Times -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Plus -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: LPar -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Character -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Bs -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Dot -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: LBr -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character3: Pipe -> REDUCE: Node -> Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs3: Character -> GOTO: Character9
Bs3: Bs -> GOTO: Bs9
Bs3: Dot -> GOTO: Dot9
Dot3: RPar -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Times -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Plus -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: LPar -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Character -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Bs -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Dot -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: LBr -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot3: Pipe -> REDUCE: Node -> Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
LBr3: List4ListOfItem -> GOTO: List4ListOfItem2
LBr3: Up -> GOTO: Up2
LBr3: Item -> GOTO: Item1
LBr3: Character -> GOTO: Character5
LBr3: Bs -> GOTO: Bs5
LBr3: Dot -> GOTO: Dot5
Character4: End -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Times -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Plus -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: LPar -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Character -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Bs -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Dot -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: LBr -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character4: Pipe -> REDUCE: Node -> Bs Character • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: End -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Times -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Plus -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: LPar -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Character -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Bs -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Dot -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: LBr -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs4: Pipe -> REDUCE: Node -> Bs Bs • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: End -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Times -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Plus -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: LPar -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Character -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Bs -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Dot -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: LBr -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot4: Pipe -> REDUCE: Node -> Bs Dot • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
List4ListOfItem1: RBr -> GOTO: RBr1
List4ListOfItem1: Item -> GOTO: Item3
List4ListOfItem1: Character -> GOTO: Character5
List4ListOfItem1: Bs -> GOTO: Bs5
List4ListOfItem1: Dot -> GOTO: Dot5
Up1: List4ListOfItem -> GOTO: List4ListOfItem3
Up1: Item -> GOTO: Item1
Up1: Character -> GOTO: Character5
Up1: Bs -> GOTO: Bs5
Up1: Dot -> GOTO: Dot5
Item1: RBr -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Bs, Dot]
Item1: Character -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Bs, Dot]
Item1: Bs -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Bs, Dot]
Item1: Dot -> REDUCE: List4ListOfItem -> Item • [RBr, Character, Bs, Dot]
Character5: RBr -> REDUCE: Item -> Character • [RBr, Character, Bs, Dot]
Character5: Character -> REDUCE: Item -> Character • [RBr, Character, Bs, Dot]
Character5: Bs -> REDUCE: Item -> Character • [RBr, Character, Bs, Dot]
Character5: Dot -> REDUCE: Item -> Character • [RBr, Character, Bs, Dot]
Character5: Minus -> GOTO: Minus1
Bs5: RBr -> REDUCE: Item -> Bs • [RBr, Character, Bs, Dot]
Bs5: Character -> REDUCE: Item -> Bs • [RBr, Character, Bs, Dot]
Bs5: Bs -> REDUCE: Item -> Bs • [RBr, Character, Bs, Dot]
Bs5: Dot -> REDUCE: Item -> Bs • [RBr, Character, Bs, Dot]
Dot5: RBr -> REDUCE: Item -> Dot • [RBr, Character, Bs, Dot]
Dot5: Character -> REDUCE: Item -> Dot • [RBr, Character, Bs, Dot]
Dot5: Bs -> REDUCE: Item -> Dot • [RBr, Character, Bs, Dot]
Dot5: Dot -> REDUCE: Item -> Dot • [RBr, Character, Bs, Dot]
Chain3: End -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
Chain3: Pipe -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [End, Pipe]
RPar1: End -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Times -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Plus -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: LPar -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Character -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Bs -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Dot -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: LBr -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar1: Pipe -> REDUCE: Node -> LPar Pattern RPar • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Pipe2: Chain -> GOTO: Chain5
Pipe2: List4ListOfNode -> GOTO: List4ListOfNode2
Pipe2: Node -> GOTO: Node3
Pipe2: LPar -> GOTO: LPar3
Pipe2: Character -> GOTO: Character3
Pipe2: Bs -> GOTO: Bs3
Pipe2: Dot -> GOTO: Dot3
Pipe2: LBr -> GOTO: LBr3
Node5: RPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: LPar -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: Character -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: Bs -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: Dot -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: LBr -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: Pipe -> REDUCE: List4ListOfNode -> List4ListOfNode Node • [RPar, LPar, Character, Bs, Dot, LBr, Pipe]
Node5: Times -> GOTO: Times3
Node5: Plus -> GOTO: Plus3
Times3: RPar -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Times -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Plus -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: LPar -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Character -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Bs -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Dot -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: LBr -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Times3: Pipe -> REDUCE: Node -> Node Times • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: RPar -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Times -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Plus -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: LPar -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Character -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Bs -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Dot -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: LBr -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Plus3: Pipe -> REDUCE: Node -> Node Plus • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Pattern3: RPar -> GOTO: RPar2
Character9: RPar -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Times -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Plus -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: LPar -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Character -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Bs -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Dot -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: LBr -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character9: Pipe -> REDUCE: Node -> Bs Character • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: RPar -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Times -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Plus -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: LPar -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Character -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Bs -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Dot -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: LBr -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Bs9: Pipe -> REDUCE: Node -> Bs Bs • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: RPar -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Times -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Plus -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: LPar -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Character -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Bs -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Dot -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: LBr -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Dot9: Pipe -> REDUCE: Node -> Bs Dot • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
List4ListOfItem2: RBr -> GOTO: RBr2
List4ListOfItem2: Item -> GOTO: Item3
List4ListOfItem2: Character -> GOTO: Character5
List4ListOfItem2: Bs -> GOTO: Bs5
List4ListOfItem2: Dot -> GOTO: Dot5
Up2: List4ListOfItem -> GOTO: List4ListOfItem4
Up2: Item -> GOTO: Item1
Up2: Character -> GOTO: Character5
Up2: Bs -> GOTO: Bs5
Up2: Dot -> GOTO: Dot5
RBr1: End -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Times -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Plus -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: LPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Character -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Bs -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Dot -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: LBr -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr1: Pipe -> REDUCE: Node -> LBr List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Item3: RBr -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Bs, Dot]
Item3: Character -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Bs, Dot]
Item3: Bs -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Bs, Dot]
Item3: Dot -> REDUCE: List4ListOfItem -> List4ListOfItem Item • [RBr, Character, Bs, Dot]
List4ListOfItem3: RBr -> GOTO: RBr3
List4ListOfItem3: Item -> GOTO: Item3
List4ListOfItem3: Character -> GOTO: Character5
List4ListOfItem3: Bs -> GOTO: Bs5
List4ListOfItem3: Dot -> GOTO: Dot5
Minus1: Character -> GOTO: Character17
Chain5: RPar -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
Chain5: Pipe -> REDUCE: ListOfChain -> ListOfChain Pipe Chain • [RPar, Pipe]
RPar2: RPar -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Times -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Plus -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: LPar -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Character -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Bs -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Dot -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: LBr -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RPar2: Pipe -> REDUCE: Node -> LPar Pattern RPar • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: RPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Times -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Plus -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: LPar -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Character -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Bs -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Dot -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: LBr -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr2: Pipe -> REDUCE: Node -> LBr List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
List4ListOfItem4: RBr -> GOTO: RBr4
List4ListOfItem4: Item -> GOTO: Item3
List4ListOfItem4: Character -> GOTO: Character5
List4ListOfItem4: Bs -> GOTO: Bs5
List4ListOfItem4: Dot -> GOTO: Dot5
RBr3: End -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Times -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Plus -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: LPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Character -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Bs -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Dot -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: LBr -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr3: Pipe -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [End, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
Character17: RBr -> REDUCE: Item -> Character Minus Character • [RBr, Character, Bs, Dot]
Character17: Character -> REDUCE: Item -> Character Minus Character • [RBr, Character, Bs, Dot]
Character17: Bs -> REDUCE: Item -> Character Minus Character • [RBr, Character, Bs, Dot]
Character17: Dot -> REDUCE: Item -> Character Minus Character • [RBr, Character, Bs, Dot]
RBr4: RPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Times -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Plus -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: LPar -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Character -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Bs -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Dot -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: LBr -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]
RBr4: Pipe -> REDUCE: Node -> LBr Up List4ListOfItem RBr • [RPar, Times, Plus, LPar, Character, Bs, Dot, LBr, Pipe]

*/

import foundation.rpg.parser.UnexpectedInputException;
import foundation.rpg.parser.StateBase;

// Generated visitor pattern based state for grammar parser.
public class State extends StateBase<foundation.rpg.lexer.regular.ast.Pattern> {

// Ignored:
// Symbols:
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPipe(foundation.rpg.common.Pipe symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLPar(foundation.rpg.common.LPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRPar(foundation.rpg.common.RPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitTimes(foundation.rpg.common.Times symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPlus(foundation.rpg.common.Plus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitCharacter(java.lang.Character symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitBs(foundation.rpg.common.Bs symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitDot(foundation.rpg.common.Dot symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLBr(foundation.rpg.common.LBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRBr(foundation.rpg.common.RBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitUp(foundation.rpg.common.Up symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitMinus(foundation.rpg.common.Minus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPattern(foundation.rpg.lexer.regular.ast.Pattern symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitListOfChain(java.util.List<foundation.rpg.lexer.regular.ast.Chain> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitChain(foundation.rpg.lexer.regular.ast.Chain symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList4ListOfNode(java.util.List<foundation.rpg.lexer.regular.ast.Node> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitNode(foundation.rpg.lexer.regular.ast.Node symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitList4ListOfItem(java.util.List<foundation.rpg.lexer.regular.ast.Item> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitItem(foundation.rpg.lexer.regular.ast.Item symbol) throws UnexpectedInputException {
        return error(symbol);
    }


}
