/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular.dfa;

import foundation.rpg.lexer.regular.Bfs;
import foundation.rpg.lexer.regular.ast.Char;
import foundation.rpg.lexer.regular.ast.Inversion;
import foundation.rpg.lexer.regular.ast.Node;
import foundation.rpg.lexer.regular.dfa.DFA;
import foundation.rpg.lexer.regular.dfa.StateSet;
import foundation.rpg.lexer.regular.thompson.GNFA;
import foundation.rpg.lexer.regular.thompson.State;
import foundation.rpg.lexer.regular.thompson.ThompsonVisitor;
import foundation.rpg.parser.Lexer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class GNFATransformer {
    public DFA transform(GNFA gnfa) {
        StateSet stateSet = new StateSet();
        State start = gnfa.getStart();
        stateSet.add(start);
        this.e(stateSet);
        LinkedHashMap cache = new LinkedHashMap();
        Bfs.bfs((set, queue) -> {
            LinkedHashMap<Node, StateSet> trans = new LinkedHashMap<Node, StateSet>();
            LinkedHashMap<Node, StateSet> groups = new LinkedHashMap<Node, StateSet>();
            LinkedHashSet inv = new LinkedHashSet();
            StateSet defaultState = new StateSet();
            set.getStates().stream().flatMap(s -> s.getTransitions().stream()).filter(t -> t.getNode() != ThompsonVisitor.epsilon).forEach(t -> {
                if (t.getNode() instanceof Inversion) {
                    defaultState.add(t.getNext());
                    set.addFailOn((Inversion)t.getNode());
                } else {
                    (t.getNode() instanceof Char ? trans : groups).computeIfAbsent(t.getNode(), k -> new StateSet()).add(t.getNext());
                }
            });
            if (!defaultState.getStates().isEmpty()) {
                this.e(defaultState);
                queue.accept(defaultState);
                set.setDefaultState(cache.computeIfAbsent(defaultState, k -> k));
            }
            groups.forEach((a, s) -> {
                this.e((StateSet)s);
                StateSet cachedSet = cache.computeIfAbsent(s, k -> k);
                trans.forEach((c, as) -> {
                    if (this.isInGroup(a.toString(), c.toString())) {
                        as.addAll((StateSet)s);
                    }
                });
                set.setGroupTransition((Node)a, cachedSet);
                queue.accept(s);
            });
            trans.forEach((a, s) -> {
                this.e((StateSet)s);
                set.setCharTransition((Node)a, cache.computeIfAbsent(s, k -> k));
                queue.accept(s);
            });
        }, Collections.singleton(stateSet));
        return new DFA(stateSet);
    }

    private void e(StateSet stateSet) {
        Bfs.bfs((state, queue) -> state.getTransitions().forEach(t -> {
            if (t.getNode() == ThompsonVisitor.epsilon) {
                stateSet.add(t.getNext());
                queue.accept(t.getNext());
            }
        }), stateSet.getStates());
    }

    private boolean isInGroup(String g, String c) {
        return Lexer.matchesGroup((String)g.substring(1), (int)c.charAt(0));
    }
}

