/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lexer.regular.ast;

import foundation.rpg.lexer.regular.Visitor;
import foundation.rpg.lexer.regular.ast.Item;
import foundation.rpg.lexer.regular.ast.Node;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Range
implements Node,
Item {
    private final char start;
    private final char end;

    public Range(char start, char end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    public char getStart() {
        return this.start;
    }

    public char getEnd() {
        return this.end;
    }

    @Override
    public Stream<Character> getChars() {
        return IntStream.rangeClosed(this.start, this.end).mapToObj(i -> Character.valueOf((char)i));
    }
}

