/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.pattern;

/*

Tilda6: {
	Chunk -> LBr Tilda • ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> • [RBr, Character]
	ListOfItem -> • ListOfItem Item [RBr, Character]
}

*/

import foundation.rpg.parser.UnexpectedInputException;
import javax.annotation.Generated;

@Generated("Generated visitor pattern based state for grammar parser.")
public class StateTilda6 extends StackState<foundation.rpg.common.Tilda, StackState<foundation.rpg.common.LBr, ? extends State>> {
// Stack:
    public StateTilda6(foundation.rpg.common.Tilda node, StackState<foundation.rpg.common.LBr, ? extends State> prev) {
        super(node, prev);
    }


// Reduce:
    @Override
    public State visitRBr(foundation.rpg.common.RBr symbol) throws UnexpectedInputException {
        
        return this.visitListOfItem(foundation.rpg.lexer.pattern.PatternFactory.is1()).visitRBr(symbol);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) throws UnexpectedInputException {
        
        return this.visitListOfItem(foundation.rpg.lexer.pattern.PatternFactory.is1()).visitCharacter(symbol);
    }


// Shift:
    @Override
    public State visitListOfItem(java.util.List<foundation.rpg.lexer.pattern.Item> symbol) {
        return new StateListOfItem4(symbol, this);
    }


// Accept:
}
