/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.pattern;

/*

ListOfUnit3: {
	Option -> ListOfUnit • [RPar, Pipe]
	ListOfUnit -> ListOfUnit • Unit [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Unit -> • Chunk Occurrence [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Character [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Dot [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Minus [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Tilda [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Tilda [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Times [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Plus [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Dot [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Character [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr Tilda ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LPar ListOfOption RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}

*/

import foundation.rpg.parser.UnexpectedInputException;
import javax.annotation.Generated;

@Generated("Generated visitor pattern based state for grammar parser.")
public class StateListOfUnit3 extends StackState<java.util.List<foundation.rpg.lexer.pattern.Unit>, State> {
// Stack:
    public StateListOfUnit3(java.util.List<foundation.rpg.lexer.pattern.Unit> node, State prev) {
        super(node, prev);
    }


// Reduce:
    @Override
    public State visitPipe(foundation.rpg.common.Pipe symbol) throws UnexpectedInputException {
        
		State stack1 = this.getPrev();
        return stack1.visitOption(foundation.rpg.lexer.pattern.PatternFactory.is1(this.getNode())).visitPipe(symbol);
    }


// Shift:
    @Override
    public State visitRPar(foundation.rpg.common.RPar symbol) {
        return new StateRPar3(symbol, this);
    }

    @Override
    public State visitUnit(foundation.rpg.lexer.pattern.Unit symbol) {
        return new StateUnit2(symbol, this);
    }

    @Override
    public State visitChunk(foundation.rpg.lexer.pattern.Chunk symbol) {
        return new StateChunk2(symbol, this);
    }

    @Override
    public State visitCharacter(java.lang.Character symbol) {
        return new StateCharacter4(symbol, this);
    }

    @Override
    public State visitDot(foundation.rpg.common.Dot symbol) {
        return new StateDot3(symbol, this);
    }

    @Override
    public State visitMinus(foundation.rpg.common.Minus symbol) {
        return new StateMinus2(symbol, this);
    }

    @Override
    public State visitTilda(foundation.rpg.common.Tilda symbol) {
        return new StateTilda4(symbol, this);
    }

    @Override
    public State visitRBr(foundation.rpg.common.RBr symbol) {
        return new StateRBr3(symbol, this);
    }

    @Override
    public State visitBs(foundation.rpg.common.Bs symbol) {
        return new StateBs2(symbol, this);
    }

    @Override
    public State visitLBr(foundation.rpg.common.LBr symbol) {
        return new StateLBr3(symbol, this);
    }

    @Override
    public State visitLPar(foundation.rpg.common.LPar symbol) {
        return new StateLPar3(symbol, this);
    }


// Accept:
}
