/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2020, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package foundation.rpg.lexer.pattern;

/*

N = [Start, Pattern, ListOfOption, Option, ListOfUnit, Unit, Chunk, ListOfItem, Item, Occurrence]
T = [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, Times, Plus, LPar, LBr]
S = Start
R = {
	Start -> [Pattern, End]
	Pattern -> [ListOfOption]
	ListOfOption -> [Option]
	ListOfOption -> [ListOfOption, Pipe, Option]
	Option -> [ListOfUnit]
	ListOfUnit -> []
	ListOfUnit -> [ListOfUnit, Unit]
	Unit -> [Chunk, Occurrence]
	Chunk -> [Character]
	Chunk -> [Dot]
	Chunk -> [Minus]
	Chunk -> [Tilda]
	Chunk -> [RPar]
	Chunk -> [RBr]
	Chunk -> [Bs, Tilda]
	Chunk -> [Bs, Times]
	Chunk -> [Bs, Plus]
	Chunk -> [Bs, Dot]
	Chunk -> [Bs, LPar]
	Chunk -> [Bs, LBr]
	Chunk -> [Bs, Character]
	Chunk -> [LBr, ListOfItem, RBr]
	Chunk -> [LBr, Tilda, ListOfItem, RBr]
	ListOfItem -> []
	ListOfItem -> [ListOfItem, Item]
	Item -> [Character]
	Item -> [Character, Minus, Character]
	Chunk -> [LPar, ListOfOption, RPar]
	Occurrence -> []
	Occurrence -> [Times]
	Occurrence -> [Plus]
}

1: {
	Start -> • Pattern End []
	Pattern -> • ListOfOption [End]
	ListOfOption -> • Option [End, Pipe]
	ListOfOption -> • ListOfOption Pipe Option [End, Pipe]
	Option -> • ListOfUnit [End, Pipe]
	ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfUnit -> • ListOfUnit Unit [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Pattern1: {
	Start -> Pattern • End []
}
ListOfOption1: {
	Pattern -> ListOfOption • [End]
	ListOfOption -> ListOfOption • Pipe Option [End, Pipe]
}
Option1: {
	ListOfOption -> Option • [End, Pipe]
}
ListOfUnit1: {
	Option -> ListOfUnit • [End, Pipe]
	ListOfUnit -> ListOfUnit • Unit [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Unit -> • Chunk Occurrence [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Character [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Dot [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Minus [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Tilda [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Tilda [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Times [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Plus [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Dot [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Character [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr ListOfItem RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr Tilda ListOfItem RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LPar ListOfOption RPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
End1: {
	Start -> Pattern End • []
}
Pipe1: {
	ListOfOption -> ListOfOption Pipe • Option [End, Pipe]
	Option -> • ListOfUnit [End, Pipe]
	ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
	ListOfUnit -> • ListOfUnit Unit [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
}
Unit1: {
	ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Chunk1: {
	Unit -> Chunk • Occurrence [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • Times [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • Plus [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Character1: {
	Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Dot1: {
	Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Minus1: {
	Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Tilda1: {
	Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
RPar1: {
	Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
RBr1: {
	Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Bs1: {
	Chunk -> Bs • Tilda [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Times [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Plus [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Dot [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • LPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • LBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Character [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
LBr1: {
	Chunk -> LBr • ListOfItem RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> LBr • Tilda ListOfItem RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> • [RBr, Character]
	ListOfItem -> • ListOfItem Item [RBr, Character]
}
LPar1: {
	Chunk -> LPar • ListOfOption RPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfOption -> • Option [RPar, Pipe]
	ListOfOption -> • ListOfOption Pipe Option [RPar, Pipe]
	Option -> • ListOfUnit [RPar, Pipe]
	ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfUnit -> • ListOfUnit Unit [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Option2: {
	ListOfOption -> ListOfOption Pipe Option • [End, Pipe]
}
Occurrence1: {
	Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Times1: {
	Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Plus1: {
	Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Tilda2: {
	Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Times2: {
	Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Plus2: {
	Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Dot2: {
	Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
LPar2: {
	Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
LBr2: {
	Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Character2: {
	Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
ListOfItem1: {
	Chunk -> LBr ListOfItem • RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> ListOfItem • Item [RBr, Character]
	Item -> • Character [RBr, Character]
	Item -> • Character Minus Character [RBr, Character]
}
Tilda3: {
	Chunk -> LBr Tilda • ListOfItem RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> • [RBr, Character]
	ListOfItem -> • ListOfItem Item [RBr, Character]
}
ListOfOption2: {
	Chunk -> LPar ListOfOption • RPar [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfOption -> ListOfOption • Pipe Option [RPar, Pipe]
}
Option3: {
	ListOfOption -> Option • [RPar, Pipe]
}
ListOfUnit3: {
	Option -> ListOfUnit • [RPar, Pipe]
	ListOfUnit -> ListOfUnit • Unit [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Unit -> • Chunk Occurrence [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Character [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Dot [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Minus [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Tilda [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Tilda [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Times [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Plus [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Dot [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs LBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • Bs Character [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LBr Tilda ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> • LPar ListOfOption RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
RBr2: {
	Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Item1: {
	ListOfItem -> ListOfItem Item • [RBr, Character]
}
Character3: {
	Item -> Character • [RBr, Character]
	Item -> Character • Minus Character [RBr, Character]
}
ListOfItem2: {
	Chunk -> LBr Tilda ListOfItem • RBr [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> ListOfItem • Item [RBr, Character]
	Item -> • Character [RBr, Character]
	Item -> • Character Minus Character [RBr, Character]
}
RPar2: {
	Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Pipe2: {
	ListOfOption -> ListOfOption Pipe • Option [RPar, Pipe]
	Option -> • ListOfUnit [RPar, Pipe]
	ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
	ListOfUnit -> • ListOfUnit Unit [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
}
Unit2: {
	ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Chunk2: {
	Unit -> Chunk • Occurrence [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • Times [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Occurrence -> • Plus [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Character4: {
	Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Dot3: {
	Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Minus2: {
	Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Tilda4: {
	Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
RPar3: {
	Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
RBr3: {
	Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Bs2: {
	Chunk -> Bs • Tilda [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Times [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Plus [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Dot [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • LPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • LBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> Bs • Character [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
LBr3: {
	Chunk -> LBr • ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	Chunk -> LBr • Tilda ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> • [RBr, Character]
	ListOfItem -> • ListOfItem Item [RBr, Character]
}
LPar3: {
	Chunk -> LPar • ListOfOption RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfOption -> • Option [RPar, Pipe]
	ListOfOption -> • ListOfOption Pipe Option [RPar, Pipe]
	Option -> • ListOfUnit [RPar, Pipe]
	ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfUnit -> • ListOfUnit Unit [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Minus3: {
	Item -> Character Minus • Character [RBr, Character]
}
RBr4: {
	Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
}
Option4: {
	ListOfOption -> ListOfOption Pipe Option • [RPar, Pipe]
}
Occurrence2: {
	Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Times3: {
	Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Plus3: {
	Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Tilda5: {
	Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Times4: {
	Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Plus4: {
	Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Dot4: {
	Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
LPar4: {
	Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
LBr4: {
	Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
Character6: {
	Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
ListOfItem3: {
	Chunk -> LBr ListOfItem • RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> ListOfItem • Item [RBr, Character]
	Item -> • Character [RBr, Character]
	Item -> • Character Minus Character [RBr, Character]
}
Tilda6: {
	Chunk -> LBr Tilda • ListOfItem RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> • [RBr, Character]
	ListOfItem -> • ListOfItem Item [RBr, Character]
}
ListOfOption3: {
	Chunk -> LPar ListOfOption • RPar [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfOption -> ListOfOption • Pipe Option [RPar, Pipe]
}
Character7: {
	Item -> Character Minus Character • [RBr, Character]
}
RBr5: {
	Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
ListOfItem4: {
	Chunk -> LBr Tilda ListOfItem • RBr [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
	ListOfItem -> ListOfItem • Item [RBr, Character]
	Item -> • Character [RBr, Character]
	Item -> • Character Minus Character [RBr, Character]
}
RPar4: {
	Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}
RBr6: {
	Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
}

1: End -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Character -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Dot -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Minus -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Tilda -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: RPar -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: RBr -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Bs -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: LBr -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: LPar -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Pipe -> REDUCE: ListOfUnit -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
1: Pattern -> GOTO: Pattern1
1: ListOfOption -> GOTO: ListOfOption1
1: Option -> GOTO: Option1
1: ListOfUnit -> GOTO: ListOfUnit1
Pattern1: End -> GOTO: End1
ListOfOption1: End -> REDUCE: Pattern -> ListOfOption • [End]
ListOfOption1: Pipe -> GOTO: Pipe1
Option1: End -> REDUCE: ListOfOption -> Option • [End, Pipe]
Option1: Pipe -> REDUCE: ListOfOption -> Option • [End, Pipe]
ListOfUnit1: End -> REDUCE: Option -> ListOfUnit • [End, Pipe]
ListOfUnit1: Pipe -> REDUCE: Option -> ListOfUnit • [End, Pipe]
ListOfUnit1: Unit -> GOTO: Unit1
ListOfUnit1: Chunk -> GOTO: Chunk1
ListOfUnit1: Character -> GOTO: Character1
ListOfUnit1: Dot -> GOTO: Dot1
ListOfUnit1: Minus -> GOTO: Minus1
ListOfUnit1: Tilda -> GOTO: Tilda1
ListOfUnit1: RPar -> GOTO: RPar1
ListOfUnit1: RBr -> GOTO: RBr1
ListOfUnit1: Bs -> GOTO: Bs1
ListOfUnit1: LBr -> GOTO: LBr1
ListOfUnit1: LPar -> GOTO: LPar1
End1:  -> ACCEPT: Start -> Pattern End • []
Pipe1: End -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Pipe -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Character -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Dot -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Minus -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Tilda -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: RPar -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: RBr -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Bs -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: LBr -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: LPar -> REDUCE: ListOfUnit -> • [End, Pipe, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar]
Pipe1: Option -> GOTO: Option2
Pipe1: ListOfUnit -> GOTO: ListOfUnit1
Unit1: End -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Character -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Dot -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Minus -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Tilda -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: RPar -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: RBr -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Bs -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: LBr -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: LPar -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Unit1: Pipe -> REDUCE: ListOfUnit -> ListOfUnit Unit • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: End -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Character -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Dot -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Minus -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Tilda -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: RPar -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: RBr -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Bs -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: LBr -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: LPar -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Pipe -> REDUCE: Occurrence -> • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Chunk1: Occurrence -> GOTO: Occurrence1
Chunk1: Times -> GOTO: Times1
Chunk1: Plus -> GOTO: Plus1
Character1: Times -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Plus -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: End -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Character -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Dot -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Minus -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Tilda -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: RPar -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: RBr -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Bs -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: LBr -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: LPar -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character1: Pipe -> REDUCE: Chunk -> Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Times -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Plus -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: End -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Character -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Dot -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Minus -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Tilda -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: RPar -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: RBr -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Bs -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: LBr -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: LPar -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot1: Pipe -> REDUCE: Chunk -> Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Times -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Plus -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: End -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Character -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Dot -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Minus -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Tilda -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: RPar -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: RBr -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Bs -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: LBr -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: LPar -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Minus1: Pipe -> REDUCE: Chunk -> Minus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Times -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Plus -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: End -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Character -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Dot -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Minus -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Tilda -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: RPar -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: RBr -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Bs -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: LBr -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: LPar -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda1: Pipe -> REDUCE: Chunk -> Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Times -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Plus -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: End -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Character -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Dot -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Minus -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Tilda -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: RPar -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: RBr -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Bs -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: LBr -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: LPar -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar1: Pipe -> REDUCE: Chunk -> RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Times -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Plus -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: End -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Character -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Dot -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Minus -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Tilda -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: RPar -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: RBr -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Bs -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: LBr -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: LPar -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr1: Pipe -> REDUCE: Chunk -> RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Bs1: Tilda -> GOTO: Tilda2
Bs1: Times -> GOTO: Times2
Bs1: Plus -> GOTO: Plus2
Bs1: Dot -> GOTO: Dot2
Bs1: LPar -> GOTO: LPar2
Bs1: LBr -> GOTO: LBr2
Bs1: Character -> GOTO: Character2
LBr1: RBr -> REDUCE: ListOfItem -> • [RBr, Character]
LBr1: Character -> REDUCE: ListOfItem -> • [RBr, Character]
LBr1: ListOfItem -> GOTO: ListOfItem1
LBr1: Tilda -> GOTO: Tilda3
LPar1: RPar -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Character -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Dot -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Minus -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Tilda -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: RBr -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Bs -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: LBr -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: LPar -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: Pipe -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar1: ListOfOption -> GOTO: ListOfOption2
LPar1: Option -> GOTO: Option3
LPar1: ListOfUnit -> GOTO: ListOfUnit3
Option2: End -> REDUCE: ListOfOption -> ListOfOption Pipe Option • [End, Pipe]
Option2: Pipe -> REDUCE: ListOfOption -> ListOfOption Pipe Option • [End, Pipe]
Occurrence1: End -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Character -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Dot -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Minus -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Tilda -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: RPar -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: RBr -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Bs -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: LBr -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: LPar -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Occurrence1: Pipe -> REDUCE: Unit -> Chunk Occurrence • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: End -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Character -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Dot -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Minus -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Tilda -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: RPar -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: RBr -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Bs -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: LBr -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: LPar -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times1: Pipe -> REDUCE: Occurrence -> Times • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: End -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Character -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Dot -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Minus -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Tilda -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: RPar -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: RBr -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Bs -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: LBr -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: LPar -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus1: Pipe -> REDUCE: Occurrence -> Plus • [End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Times -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Plus -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: End -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Character -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Dot -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Minus -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Tilda -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: RPar -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: RBr -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Bs -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: LBr -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: LPar -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Tilda2: Pipe -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Times -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Plus -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: End -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Character -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Dot -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Minus -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Tilda -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: RPar -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: RBr -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Bs -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: LBr -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: LPar -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Times2: Pipe -> REDUCE: Chunk -> Bs Times • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Times -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Plus -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: End -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Character -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Dot -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Minus -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Tilda -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: RPar -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: RBr -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Bs -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: LBr -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: LPar -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Plus2: Pipe -> REDUCE: Chunk -> Bs Plus • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Times -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Plus -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: End -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Character -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Dot -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Minus -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Tilda -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: RPar -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: RBr -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Bs -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: LBr -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: LPar -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Dot2: Pipe -> REDUCE: Chunk -> Bs Dot • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Times -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Plus -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: End -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Character -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Dot -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Minus -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Tilda -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: RPar -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: RBr -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Bs -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: LBr -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: LPar -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LPar2: Pipe -> REDUCE: Chunk -> Bs LPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Times -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Plus -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: End -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Character -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Dot -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Minus -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Tilda -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: RPar -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: RBr -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Bs -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: LBr -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: LPar -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
LBr2: Pipe -> REDUCE: Chunk -> Bs LBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Times -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Plus -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: End -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Character -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Dot -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Minus -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Tilda -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: RPar -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: RBr -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Bs -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: LBr -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: LPar -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Character2: Pipe -> REDUCE: Chunk -> Bs Character • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
ListOfItem1: RBr -> GOTO: RBr2
ListOfItem1: Item -> GOTO: Item1
ListOfItem1: Character -> GOTO: Character3
Tilda3: RBr -> REDUCE: ListOfItem -> • [RBr, Character]
Tilda3: Character -> REDUCE: ListOfItem -> • [RBr, Character]
Tilda3: ListOfItem -> GOTO: ListOfItem2
ListOfOption2: RPar -> GOTO: RPar2
ListOfOption2: Pipe -> GOTO: Pipe2
Option3: RPar -> REDUCE: ListOfOption -> Option • [RPar, Pipe]
Option3: Pipe -> REDUCE: ListOfOption -> Option • [RPar, Pipe]
ListOfUnit3: RPar -> GOTO: RPar3
ListOfUnit3: Pipe -> REDUCE: Option -> ListOfUnit • [RPar, Pipe]
ListOfUnit3: Unit -> GOTO: Unit2
ListOfUnit3: Chunk -> GOTO: Chunk2
ListOfUnit3: Character -> GOTO: Character4
ListOfUnit3: Dot -> GOTO: Dot3
ListOfUnit3: Minus -> GOTO: Minus2
ListOfUnit3: Tilda -> GOTO: Tilda4
ListOfUnit3: RBr -> GOTO: RBr3
ListOfUnit3: Bs -> GOTO: Bs2
ListOfUnit3: LBr -> GOTO: LBr3
ListOfUnit3: LPar -> GOTO: LPar3
RBr2: Times -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Plus -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: End -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Character -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Dot -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Minus -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Tilda -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: RPar -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: RBr -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Bs -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: LBr -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: LPar -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr2: Pipe -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Item1: RBr -> REDUCE: ListOfItem -> ListOfItem Item • [RBr, Character]
Item1: Character -> REDUCE: ListOfItem -> ListOfItem Item • [RBr, Character]
Character3: RBr -> REDUCE: Item -> Character • [RBr, Character]
Character3: Character -> REDUCE: Item -> Character • [RBr, Character]
Character3: Minus -> GOTO: Minus3
ListOfItem2: RBr -> GOTO: RBr4
ListOfItem2: Item -> GOTO: Item1
ListOfItem2: Character -> GOTO: Character3
RPar2: Times -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Plus -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: End -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Character -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Dot -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Minus -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Tilda -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: RPar -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: RBr -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Bs -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: LBr -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: LPar -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RPar2: Pipe -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Pipe2: RPar -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Pipe -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Character -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Dot -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Minus -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Tilda -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: RBr -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Bs -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: LBr -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: LPar -> REDUCE: ListOfUnit -> • [RPar, Pipe, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar]
Pipe2: Option -> GOTO: Option4
Pipe2: ListOfUnit -> GOTO: ListOfUnit3
Unit2: RPar -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Character -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Dot -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Minus -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Tilda -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: RBr -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Bs -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: LBr -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: LPar -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Unit2: Pipe -> REDUCE: ListOfUnit -> ListOfUnit Unit • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: RPar -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Character -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Dot -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Minus -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Tilda -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: RBr -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Bs -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: LBr -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: LPar -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Pipe -> REDUCE: Occurrence -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Chunk2: Occurrence -> GOTO: Occurrence2
Chunk2: Times -> GOTO: Times3
Chunk2: Plus -> GOTO: Plus3
Character4: Times -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Plus -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: RPar -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Character -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Dot -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Minus -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Tilda -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: RBr -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Bs -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: LBr -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: LPar -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character4: Pipe -> REDUCE: Chunk -> Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Times -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Plus -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: RPar -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Character -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Dot -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Minus -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Tilda -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: RBr -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Bs -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: LBr -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: LPar -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot3: Pipe -> REDUCE: Chunk -> Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Times -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Plus -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: RPar -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Character -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Dot -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Minus -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Tilda -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: RBr -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Bs -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: LBr -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: LPar -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Minus2: Pipe -> REDUCE: Chunk -> Minus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Times -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Plus -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: RPar -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Character -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Dot -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Minus -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Tilda -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: RBr -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Bs -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: LBr -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: LPar -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda4: Pipe -> REDUCE: Chunk -> Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Times -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Plus -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: RPar -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Character -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Dot -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Minus -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Tilda -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: RBr -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Bs -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: LBr -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: LPar -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar3: Pipe -> REDUCE: Chunk -> RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Times -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Plus -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: RPar -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Character -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Dot -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Minus -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Tilda -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: RBr -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Bs -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: LBr -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: LPar -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr3: Pipe -> REDUCE: Chunk -> RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Bs2: Tilda -> GOTO: Tilda5
Bs2: Times -> GOTO: Times4
Bs2: Plus -> GOTO: Plus4
Bs2: Dot -> GOTO: Dot4
Bs2: LPar -> GOTO: LPar4
Bs2: LBr -> GOTO: LBr4
Bs2: Character -> GOTO: Character6
LBr3: RBr -> REDUCE: ListOfItem -> • [RBr, Character]
LBr3: Character -> REDUCE: ListOfItem -> • [RBr, Character]
LBr3: ListOfItem -> GOTO: ListOfItem3
LBr3: Tilda -> GOTO: Tilda6
LPar3: RPar -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Character -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Dot -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Minus -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Tilda -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: RBr -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Bs -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: LBr -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: LPar -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: Pipe -> REDUCE: ListOfUnit -> • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar3: ListOfOption -> GOTO: ListOfOption3
LPar3: Option -> GOTO: Option3
LPar3: ListOfUnit -> GOTO: ListOfUnit3
Minus3: Character -> GOTO: Character7
RBr4: Times -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Plus -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: End -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Character -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Dot -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Minus -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Tilda -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: RPar -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: RBr -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Bs -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: LBr -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: LPar -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
RBr4: Pipe -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, End, Character, Dot, Minus, Tilda, RPar, RBr, Bs, LBr, LPar, Pipe]
Option4: RPar -> REDUCE: ListOfOption -> ListOfOption Pipe Option • [RPar, Pipe]
Option4: Pipe -> REDUCE: ListOfOption -> ListOfOption Pipe Option • [RPar, Pipe]
Occurrence2: RPar -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Character -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Dot -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Minus -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Tilda -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: RBr -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Bs -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: LBr -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: LPar -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Occurrence2: Pipe -> REDUCE: Unit -> Chunk Occurrence • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: RPar -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Character -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Dot -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Minus -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Tilda -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: RBr -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Bs -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: LBr -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: LPar -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times3: Pipe -> REDUCE: Occurrence -> Times • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: RPar -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Character -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Dot -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Minus -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Tilda -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: RBr -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Bs -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: LBr -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: LPar -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus3: Pipe -> REDUCE: Occurrence -> Plus • [RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Times -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Plus -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: RPar -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Character -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Dot -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Minus -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Tilda -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: RBr -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Bs -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: LBr -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: LPar -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Tilda5: Pipe -> REDUCE: Chunk -> Bs Tilda • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Times -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Plus -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: RPar -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Character -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Dot -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Minus -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Tilda -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: RBr -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Bs -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: LBr -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: LPar -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Times4: Pipe -> REDUCE: Chunk -> Bs Times • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Times -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Plus -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: RPar -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Character -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Dot -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Minus -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Tilda -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: RBr -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Bs -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: LBr -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: LPar -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Plus4: Pipe -> REDUCE: Chunk -> Bs Plus • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Times -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Plus -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: RPar -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Character -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Dot -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Minus -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Tilda -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: RBr -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Bs -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: LBr -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: LPar -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Dot4: Pipe -> REDUCE: Chunk -> Bs Dot • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Times -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Plus -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: RPar -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Character -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Dot -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Minus -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Tilda -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: RBr -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Bs -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: LBr -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: LPar -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LPar4: Pipe -> REDUCE: Chunk -> Bs LPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Times -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Plus -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: RPar -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Character -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Dot -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Minus -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Tilda -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: RBr -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Bs -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: LBr -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: LPar -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
LBr4: Pipe -> REDUCE: Chunk -> Bs LBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Times -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Plus -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: RPar -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Character -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Dot -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Minus -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Tilda -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: RBr -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Bs -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: LBr -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: LPar -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
Character6: Pipe -> REDUCE: Chunk -> Bs Character • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
ListOfItem3: RBr -> GOTO: RBr5
ListOfItem3: Item -> GOTO: Item1
ListOfItem3: Character -> GOTO: Character3
Tilda6: RBr -> REDUCE: ListOfItem -> • [RBr, Character]
Tilda6: Character -> REDUCE: ListOfItem -> • [RBr, Character]
Tilda6: ListOfItem -> GOTO: ListOfItem4
ListOfOption3: RPar -> GOTO: RPar4
ListOfOption3: Pipe -> GOTO: Pipe2
Character7: RBr -> REDUCE: Item -> Character Minus Character • [RBr, Character]
Character7: Character -> REDUCE: Item -> Character Minus Character • [RBr, Character]
RBr5: Times -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Plus -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: RPar -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Character -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Dot -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Minus -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Tilda -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: RBr -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Bs -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: LBr -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: LPar -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr5: Pipe -> REDUCE: Chunk -> LBr ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
ListOfItem4: RBr -> GOTO: RBr6
ListOfItem4: Item -> GOTO: Item1
ListOfItem4: Character -> GOTO: Character3
RPar4: Times -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Plus -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: RPar -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Character -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Dot -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Minus -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Tilda -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: RBr -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Bs -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: LBr -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: LPar -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RPar4: Pipe -> REDUCE: Chunk -> LPar ListOfOption RPar • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Times -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Plus -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: RPar -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Character -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Dot -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Minus -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Tilda -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: RBr -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Bs -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: LBr -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: LPar -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]
RBr6: Pipe -> REDUCE: Chunk -> LBr Tilda ListOfItem RBr • [Times, Plus, RPar, Character, Dot, Minus, Tilda, RBr, Bs, LBr, LPar, Pipe]

*/

import foundation.rpg.parser.UnexpectedInputException;
import foundation.rpg.parser.StateBase;
import javax.annotation.Generated;

@Generated("Generated visitor pattern based state for grammar parser.")
public class State extends StateBase<foundation.rpg.lexer.pattern.Pattern> {

// Ignored:
// Symbols:
    public State visitEnd(foundation.rpg.parser.End symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPipe(foundation.rpg.common.Pipe symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitCharacter(java.lang.Character symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitDot(foundation.rpg.common.Dot symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitMinus(foundation.rpg.common.Minus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitTilda(foundation.rpg.common.Tilda symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRPar(foundation.rpg.common.RPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitRBr(foundation.rpg.common.RBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitBs(foundation.rpg.common.Bs symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitTimes(foundation.rpg.common.Times symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPlus(foundation.rpg.common.Plus symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLPar(foundation.rpg.common.LPar symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitLBr(foundation.rpg.common.LBr symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitPattern(foundation.rpg.lexer.pattern.Pattern symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitListOfOption(java.util.List<foundation.rpg.lexer.pattern.Option> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitOption(foundation.rpg.lexer.pattern.Option symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitListOfUnit(java.util.List<foundation.rpg.lexer.pattern.Unit> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitUnit(foundation.rpg.lexer.pattern.Unit symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitChunk(foundation.rpg.lexer.pattern.Chunk symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitListOfItem(java.util.List<foundation.rpg.lexer.pattern.Item> symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitItem(foundation.rpg.lexer.pattern.Item symbol) throws UnexpectedInputException {
        return error(symbol);
    }

    public State visitOccurrence(foundation.rpg.lexer.pattern.Occurrence symbol) throws UnexpectedInputException {
        return error(symbol);
    }


}
