/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AstUtils {
    public static <T> List<T> addTo(List<T> list, T item) {
        list.add(item);
        return list;
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> list(T item) {
        return AstUtils.addTo(new ArrayList(), item);
    }

    public static <T> List<T> copy(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> map(K key, V value) {
        return AstUtils.putIn(new LinkedHashMap(), key, value);
    }

    public static <K, V> Map<K, V> putIn(Map<K, V> map, K key, V value) {
        map.put(key, value);
        return map;
    }

    public static String quotedBsEscapedString(String s) {
        return s.substring(1, s.length() - 2).replace("\\" + s.charAt(0), "" + s.charAt(0));
    }

    public static <K, V> Map<K, V> putUniqueIn(Map<K, V> map, K key, V value, String errorMessage) {
        if (map.containsKey(key)) {
            throw new IllegalStateException(errorMessage);
        }
        return AstUtils.putIn(map, key, value);
    }
}

