/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.processor;

import foundation.rpg.Match;
import foundation.rpg.Name;
import foundation.rpg.lexer.LexerGenerator;
import foundation.rpg.lexer.regular.RegularParser;
import foundation.rpg.parser.Token;
import foundation.rpg.parser.generator.ClassToGrammarContext;
import foundation.rpg.parser.generator.EnvironmentGenerator;
import foundation.rpg.util.MapOfSets;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ClassToTokenContext
implements EnvironmentGenerator {
    private final RegularParser parser = new RegularParser();
    private final MapOfSets<TypeMirror, Element> tokenInfo = new MapOfSets();
    private boolean isStatic = true;

    public void accept(VariableElement var) {
        Match match = var.getAnnotation(Match.class);
        Name name = var.getAnnotation(Name.class);
        TypeMirror type = var.asType();
        if (Objects.nonNull(match) || Objects.nonNull(name)) {
            if (this.tokenInfo.get((Object)type) instanceof VariableElement) {
                throw new IllegalStateException("Token info already defined at " + this.tokenInfo.get((Object)type));
            }
            this.tokenInfo.add((Object)type, (Object)var);
            return;
        }
        if (type instanceof DeclaredType) {
            Element element = ((DeclaredType)type).asElement();
            match = element.getAnnotation(Match.class);
            name = element.getAnnotation(Name.class);
            if (Objects.nonNull(match) || Objects.nonNull(name)) {
                this.tokenInfo.add((Object)type, (Object)element);
            }
        }
    }

    public void generate(ClassToGrammarContext context, Filer filer) throws IOException {
        new LexerGenerator().generateLexer(context.getPackageName(), "GeneratedLexer", context.getGrammar().getTerminals().stream().flatMap(symbol -> {
            TypeMirror type = context.symbolType(symbol);
            return this.tokenInfoFor(type).stream();
        }).collect(Collectors.toList()), new PrintWriter(filer.createSourceFile(context.getPackageName() + ".GeneratedLexer", new Element[0]).openWriter()), context.isStaticFactory() ? null : context.getFactoryClass().asType());
    }

    public void accept(ExecutableElement method) {
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.isStatic = false;
        }
        this.tokenInfo.add((Object)method.getReturnType(), (Object)method);
    }

    public Set<Element> elementFor(TypeMirror mirror) {
        return this.tokenInfo.computeIfAbsent((Object)mirror, k -> {
            throw new IllegalArgumentException("No token defined for " + mirror + ". Use @Name or @Match annotation on " + mirror + " or in factory method.");
        });
    }

    public LexerGenerator.TokenInfo tokenInfoFor(ExecutableElement method) {
        DeclaredType returnType = (DeclaredType)method.getReturnType();
        String call = "visit" + returnType.asElement().getSimpleName() + "(" + (method.getModifiers().contains((Object)Modifier.STATIC) ? method.getEnclosingElement() : "getFactory()") + "." + method.getSimpleName() + "(builder.build()))";
        VariableElement element = method.getParameters().get(0);
        return this.tokenInfo(returnType, element, call);
    }

    public List<LexerGenerator.TokenInfo> tokenInfoFor(TypeMirror mirror) {
        Set<Element> elements = this.elementFor(mirror);
        Element typeElement = ((DeclaredType)mirror).asElement();
        return elements.stream().map(element -> {
            if (element instanceof ExecutableElement) {
                return this.tokenInfoFor((ExecutableElement)element);
            }
            boolean acceptsPosition = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().anyMatch(c -> c.getParameters().size() == 1 && c.getParameters().get(0).asType().toString().equals(Token.class.getCanonicalName()));
            String call = "visit" + typeElement.getSimpleName() + "(new " + mirror + "(" + (acceptsPosition ? "builder.build()" : "builder.build().getContent()") + "))";
            return this.tokenInfo(mirror, (Element)element, call);
        }).collect(Collectors.toList());
    }

    private LexerGenerator.TokenInfo tokenInfo(TypeMirror mirror, Element element, String call) {
        Match match = element.getAnnotation(Match.class);
        Name name = element.getAnnotation(Name.class);
        if (Objects.nonNull(match)) {
            return new LexerGenerator.TokenInfo((Object)mirror, call, this.parser.parsePattern(match.value()), match.priority());
        }
        return new LexerGenerator.TokenInfo((Object)mirror, call, this.parser.parseText(name.value()), name.priority());
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

