/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;

public class Bfs {
    public static <T> Set<T> withCollection(Collection<T> input, Iteration<T> iteration) {
        LinkedList queue = new LinkedList(input);
        LinkedHashSet visited = new LinkedHashSet(input);
        while (!queue.isEmpty()) {
            iteration.iterate(queue.poll(), next -> {
                if (visited.add(next)) {
                    queue.add(next);
                }
            });
        }
        return visited;
    }

    public static <T> Set<T> withItem(T input, Iteration<T> iteration) {
        return Bfs.withCollection(Collections.singletonList(input), iteration);
    }

    @FunctionalInterface
    public static interface Iteration<T> {
        public void iterate(T var1, Consumer<T> var2);
    }
}

