/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SymbolString
implements Iterable<Symbol> {
    private final List<Symbol> symbols;
    private final int size;
    private final int hash;

    public SymbolString(List<Symbol> symbols) {
        this.symbols = Collections.unmodifiableList(new ArrayList<Symbol>(symbols));
        this.size = symbols.size();
        this.hash = Objects.hash(symbols, this.size);
    }

    public List<Symbol> getSymbols() {
        return this.symbols;
    }

    public Symbol get(int i) {
        return this.symbols.get(i);
    }

    public int size() {
        return this.size;
    }

    public Stream<Symbol> stream() {
        return this.symbols.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolString that = (SymbolString)o;
        return this.size == that.size && Objects.equals(this.symbols, that.symbols);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.symbols.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this.symbols.iterator();
    }

    public SymbolString substring(int from) {
        return new SymbolString(from < this.size() ? this.symbols.subList(from, this.size) : Collections.emptyList());
    }
}

