/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.regular;

import foundation.rpg.gnfa.GNFA;
import foundation.rpg.gnfa.Thompson;
import foundation.rpg.regular.In;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RegularExpressionParser {
    private final Thompson thompson = new Thompson();

    public GNFA parsePattern(String string) {
        return this.parse(new In(string));
    }

    public GNFA parseText(String text) {
        return this.thompson.string(text);
    }

    GNFA parse(In in) {
        GNFA left = this.parseChain(in);
        return in.testAndConsume('|') ? this.thompson.alternation(Stream.of(left, this.parse(in))) : left;
    }

    GNFA parseEsc(In in) {
        char c = in.consume("Unfinished escape sequence");
        switch (c) {
            case '(': 
            case ')': 
            case '.': 
            case '[': 
            case '\\': 
            case '|': {
                return this.thompson.transition(Character.valueOf(c));
            }
        }
        return this.thompson.group(Character.valueOf(c));
    }

    GNFA parseChain(In in) {
        switch (in.get()) {
            case -1: 
            case 41: 
            case 124: {
                return this.thompson.empty();
            }
        }
        return this.thompson.chain(Stream.of(this.parseFactor(this.parseInput(in), in), this.parseChain(in)));
    }

    GNFA parseFactor(GNFA factor, In in) {
        if (in.testAndConsume('*')) {
            return this.thompson.repetition(factor);
        }
        if (in.testAndConsume('+')) {
            return this.thompson.chain(Stream.of(factor, this.thompson.repetition(factor)));
        }
        return factor;
    }

    GNFA parseInput(In in) {
        int c = in.consume();
        switch (c) {
            case -1: {
                return this.thompson.empty();
            }
            case 92: {
                return this.parseEsc(in);
            }
            case 46: {
                return this.thompson.any();
            }
            case 91: {
                return this.parseChars(in);
            }
            case 40: {
                GNFA sub = this.parse(in);
                if (!in.testAndConsume(')')) {
                    throw new IllegalStateException("Missing )");
                }
                return sub;
            }
        }
        return this.thompson.transition(Character.valueOf((char)c));
    }

    GNFA parseChars(In in) {
        return in.testAndConsume('^') ? this.thompson.inversions(this.parseClass(in)) : this.thompson.transitions(this.parseClass(in));
    }

    Stream<Character> parseClass(In in) {
        Stream<Character> left = this.parseCharOrRange(in);
        return in.testAndConsume(']') ? left : Stream.concat(left, this.parseClass(in));
    }

    Stream<Character> parseCharOrRange(In in) {
        in.testAndConsume('\\');
        char c = in.consume("Unterminated character class");
        return in.testAndConsume('-') ? IntStream.range(c, in.consume("Unterminated character range")).mapToObj(i -> Character.valueOf((char)i)) : Stream.of(Character.valueOf(c));
    }
}

