/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lr1;

import foundation.rpg.grammar.Rule;
import foundation.rpg.grammar.Symbol;
import foundation.rpg.grammar.SymbolString;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public final class LrItem
implements Comparable<LrItem> {
    private final int dot;
    private final Rule rule;
    private final Set<Symbol> lookahead;
    private final int hash;

    private LrItem(int dot, Rule rule, Set<Symbol> lookahead) {
        this.dot = dot;
        this.rule = rule;
        this.lookahead = Collections.unmodifiableSet(lookahead);
        this.hash = Objects.hash(dot, rule, lookahead);
    }

    public static LrItem lrItem(Rule rule, Set<Symbol> lookahead) {
        return new LrItem(0, rule, lookahead);
    }

    public static LrItem lrItem(int i, Rule rule, Set<Symbol> lookahead) {
        return new LrItem(i, rule, lookahead);
    }

    public Symbol symbolAtDot() {
        return this.rule.getRight().get(this.dot);
    }

    public boolean isEnd() {
        return this.dot >= this.rule.getRight().size();
    }

    public Set<Symbol> getLookahead() {
        return this.lookahead;
    }

    public int getDot() {
        return this.dot;
    }

    public Rule getRule() {
        return this.rule;
    }

    public LrItem moveDot() {
        return new LrItem(this.dot + 1, this.rule, this.lookahead);
    }

    @Override
    public int compareTo(LrItem o) {
        return this.dot - o.dot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LrItem lr1Item = (LrItem)o;
        return this.dot == lr1Item.dot && Objects.equals(this.rule, lr1Item.rule) && Objects.equals(this.lookahead, lr1Item.lookahead);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(" ");
        int i = 0;
        while (i < this.dot) {
            j.add(this.rule.getRight().get(i++).toString());
        }
        j.add("\u2022");
        while (i < this.rule.getRight().size()) {
            j.add(this.rule.getRight().get(i++).toString());
        }
        return this.rule.getLeft() + " -> " + j + " " + this.lookahead;
    }

    public LrItem mergeLookahead(LrItem t) {
        LinkedHashSet<Symbol> merged = new LinkedHashSet<Symbol>(t.lookahead);
        merged.addAll(this.lookahead);
        return new LrItem(this.dot, this.rule, merged);
    }

    public SymbolString afterDot() {
        return this.getRule().getRight().substring(this.getDot() + 1);
    }
}

