/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.gnfa;

import foundation.rpg.gnfa.GNFA;
import foundation.rpg.gnfa.State;
import java.util.Iterator;
import java.util.stream.Stream;

public class Thompson {
    public static final Character epsilon = null;

    public GNFA empty() {
        return this.transition(epsilon);
    }

    public GNFA transition(Character input) {
        State start = State.state(input + ">");
        State end = State.state("<" + input);
        start.add(input, end);
        return new GNFA(start, end);
    }

    public GNFA group(Character input) {
        State start = State.state(input + ":g>");
        State end = State.state("<:g" + input);
        start.addGroup(input, end);
        return new GNFA(start, end);
    }

    public GNFA any() {
        return this.inversions(Stream.empty());
    }

    public GNFA transitions(Stream<Character> inputs) {
        State start = State.state("[]>");
        State end = State.state("<[]");
        inputs.forEach(input -> start.add((Character)input, end));
        return new GNFA(start, end);
    }

    public GNFA inversions(Stream<Character> inputs) {
        State end = State.state("<[]!");
        State start = State.state("![]>", end);
        inputs.forEach(input -> start.add((Character)input, State.ERROR));
        return new GNFA(start, end);
    }

    public GNFA string(String string) {
        State start;
        State curr = start = State.state("");
        for (int i = 0; i < string.length(); ++i) {
            State next = State.state("");
            curr.add(Character.valueOf(string.charAt(i)), next);
            curr = next;
        }
        return new GNFA(start, curr);
    }

    public GNFA chain(Stream<GNFA> gnfas) {
        Iterator i = gnfas.iterator();
        if (!i.hasNext()) {
            return this.transition(epsilon);
        }
        GNFA current = (GNFA)i.next();
        State start = current.getStart();
        while (i.hasNext()) {
            GNFA next = (GNFA)i.next();
            current.getEnd().add(epsilon, next.getStart());
            current = next;
        }
        return new GNFA(start, current.getEnd());
    }

    public GNFA alternation(Stream<GNFA> gnfas) {
        State start = State.state("(");
        State end = State.state(")");
        gnfas.forEach(gnfa -> {
            start.add(epsilon, gnfa.getStart());
            gnfa.getEnd().add(epsilon, end);
        });
        return new GNFA(start, end);
    }

    public GNFA repetition(GNFA gnfa) {
        State start = State.state("rep>");
        State end = State.state("<rep");
        start.add(epsilon, end);
        gnfa.getEnd().add(epsilon, gnfa.getStart());
        start.add(epsilon, gnfa.getStart());
        gnfa.getEnd().add(epsilon, end);
        return new GNFA(start, end);
    }
}

