/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.dfa;

import foundation.rpg.gnfa.State;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StateSet {
    private static final StateSet ERROR = new StateSet(Collections.singleton(State.ERROR));
    private final Set<State> states;
    private final Map<Object, StateSet> charTransitions = new LinkedHashMap<Object, StateSet>();
    private final Map<Object, StateSet> groupTransitions = new LinkedHashMap<Object, StateSet>();
    private StateSet defaultState = ERROR;

    public StateSet(Set<State> states) {
        this.states = states;
    }

    public void setDefaultState(StateSet defaultState) {
        this.defaultState = defaultState;
    }

    public void add(State state) {
        this.states.add(state);
    }

    public Set<State> getStates() {
        return this.states;
    }

    public StateSet getDefaultState() {
        return this.defaultState;
    }

    public void setCharTransition(Object a, StateSet set) {
        this.charTransitions.put(a, set);
    }

    public void setGroupTransition(Object a, StateSet set) {
        this.groupTransitions.put(a, set);
    }

    public Map<Object, StateSet> getTransitions() {
        return this.charTransitions;
    }

    public Map<Object, StateSet> getGroups() {
        return this.groupTransitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateSet stateSet = (StateSet)o;
        return this.states.equals(stateSet.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public static boolean isError(StateSet stateSet) {
        return ERROR.equals(stateSet);
    }
}

