/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.dfa;

import foundation.rpg.dfa.DFA;
import foundation.rpg.dfa.StateSet;
import foundation.rpg.gnfa.GNFA;
import foundation.rpg.gnfa.State;
import foundation.rpg.gnfa.Thompson;
import foundation.rpg.util.Bfs;
import foundation.rpg.util.MapOfSets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class GNFATransformer {
    private final Types types;

    public GNFATransformer(Types types) {
        this.types = types;
    }

    public DFA transform(GNFA gnfa) {
        LinkedHashMap<Set<State>, StateSet> cache = new LinkedHashMap<Set<State>, StateSet>();
        StateSet stateSet = this.stateSet(new LinkedHashSet<State>(Collections.singleton(gnfa.getStart())), cache, s -> {});
        Bfs.withItem(stateSet, (set, queue) -> {
            Set<State> states = set.getStates();
            set.setDefaultState(this.stateSet(states.stream().map(State::getDefaultState).collect(Collectors.toSet()), cache, queue));
            MapOfSets groups = new MapOfSets();
            MapOfSets trans = new MapOfSets();
            Set charKeys = states.stream().flatMap(s -> s.getTransitions().keys().stream().filter(k -> k != Thompson.epsilon)).collect(Collectors.toSet());
            Set groupKeys = states.stream().flatMap(s -> s.getGroups().keys().stream().filter(k -> k != Thompson.epsilon)).collect(Collectors.toSet());
            states.forEach(s -> charKeys.forEach(k -> trans.add((Character)k, s.get((Character)k))));
            states.forEach(s -> groupKeys.forEach(k -> groups.add((Character)k, s.getGroup((Character)k))));
            groups.forEach((a, s) -> {
                trans.forEach((c, as) -> {
                    if (this.types.isInGroup((Character)a, (Character)c)) {
                        as.addAll(s);
                    }
                });
                set.setGroupTransition(a, this.stateSet((Set<State>)s, cache, queue));
            });
            trans.forEach((a, s) -> set.setCharTransition(a, this.stateSet((Set<State>)s, cache, queue)));
        });
        return new DFA(stateSet);
    }

    private static Set<State> epsilonClosure(Set<State> stateSet) {
        Bfs.withCollection(stateSet, (state, queue) -> state.getTransitions().forEach((k, n) -> {
            if (k == Thompson.epsilon) {
                stateSet.addAll((Collection<State>)n);
                n.forEach(queue);
            }
        }));
        return stateSet;
    }

    public StateSet stateSet(Set<State> states, Map<Set<State>, StateSet> cache, Consumer<StateSet> queue) {
        StateSet stateSet = cache.computeIfAbsent(GNFATransformer.epsilonClosure(states), StateSet::new);
        queue.accept(stateSet);
        return stateSet;
    }

    @FunctionalInterface
    public static interface Types {
        public boolean isInGroup(Character var1, Character var2);
    }
}

