/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.dfa;

import foundation.rpg.dfa.StateSet;
import foundation.rpg.util.Bfs;
import java.util.Set;

public class DFA {
    private final StateSet start;
    private final Set<StateSet> states;

    public DFA(StateSet start) {
        this.start = start;
        this.states = Bfs.withItem(start, (item, queue) -> {
            item.getTransitions().forEach((c, s) -> queue.accept(s));
            item.getGroups().forEach((c, s) -> queue.accept(s));
            queue.accept(item.getDefaultState());
        });
    }

    public StateSet getStart() {
        return this.start;
    }

    public Set<StateSet> getStates() {
        return this.states;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.states.forEach(item -> {
            builder.append(item.hashCode()).append(": {\n");
            item.getTransitions().forEach((c, s) -> builder.append("\t'").append(c).append("' -> ").append(s.hashCode()).append("\n"));
            item.getGroups().forEach((c, s) -> builder.append("\t\\").append(c).append(" -> ").append(s.hashCode()).append("\n"));
            builder.append("\totherwise -> ").append(item.getDefaultState().hashCode()).append("\n}\n");
        });
        return builder.toString();
    }
}

