/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Symbol;
import foundation.rpg.grammar.SymbolString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Rule {
    private final Symbol left;
    private final SymbolString right;

    public Rule(Symbol left, SymbolString right) {
        this.left = left;
        this.right = right;
    }

    public Rule(Symbol left, List<Symbol> right) {
        this(left, new SymbolString(right));
    }

    public Symbol getLeft() {
        return this.left;
    }

    public SymbolString getRight() {
        return this.right;
    }

    public static Rule rule(Symbol left, List<Symbol> right) {
        return new Rule(left, right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.left, rule.left) && Objects.equals(this.right, rule.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return this.left + " -> " + this.right;
    }

    public static Builder rule(Symbol left) {
        return right -> Rule.rule(left, right);
    }

    public static interface Builder {
        default public Rule to(Symbol ... right) {
            return this.to(Arrays.asList(right));
        }

        public Rule to(List<Symbol> var1);

        @SafeVarargs
        public static <T> Set<T> setOf(T ... items) {
            return Stream.of(items).collect(Collectors.toSet());
        }
    }
}

