/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.automata;

import foundation.rpg.automata.LrItem;
import foundation.rpg.automata.LrItemSet;
import java.util.Objects;

public interface LrAction {
    public void accept(LrActionVisitor var1);

    public static class Accept
    implements LrAction {
        private final LrItem item;

        public Accept(LrItem item) {
            this.item = item;
        }

        public String toString() {
            return "ACCEPT: " + this.item;
        }

        @Override
        public void accept(LrActionVisitor visitor) {
            visitor.visitAccept(this.item);
        }
    }

    public static class Reduce
    implements LrAction {
        private final LrItem item;

        public Reduce(LrItem item) {
            this.item = item;
        }

        public String toString() {
            return "REDUCE: " + this.item;
        }

        @Override
        public void accept(LrActionVisitor visitor) {
            visitor.visitReduction(this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reduce reduce = (Reduce)o;
            return Objects.equals(this.item.getRule(), reduce.item.getRule());
        }

        public int hashCode() {
            return Objects.hash(this.item.getRule());
        }
    }

    public static class Goto
    implements LrAction {
        private final LrItemSet to;

        public Goto(LrItemSet to) {
            this.to = to;
        }

        public String toString() {
            return "GOTO: " + this.to.getName();
        }

        @Override
        public void accept(LrActionVisitor visitor) {
            visitor.visitGoto(this.to);
        }
    }

    public static interface LrActionVisitor {
        public void visitGoto(LrItemSet var1);

        public void visitReduction(LrItem var1);

        public void visitAccept(LrItem var1);
    }
}

