/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SymbolString
implements Iterable<Symbol> {
    private final List<Symbol> symbols;
    private final int size;

    public SymbolString(List<Symbol> symbols) {
        this.symbols = Collections.unmodifiableList(new ArrayList<Symbol>(symbols));
        this.size = symbols.size();
    }

    public List<Symbol> getSymbols() {
        return this.symbols;
    }

    public Symbol get(int i) {
        return this.symbols.get(i);
    }

    public int size() {
        return this.size;
    }

    public Stream<Symbol> stream() {
        return this.symbols.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolString that = (SymbolString)o;
        return this.size == that.size && Objects.equals(this.symbols, that.symbols);
    }

    public int hashCode() {
        return Objects.hash(this.symbols, this.size);
    }

    public String toString() {
        return this.symbols.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this.symbols.iterator();
    }
}

