/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Symbol;
import foundation.rpg.grammar.SymbolString;
import java.util.List;
import java.util.Objects;

public final class Rule {
    private final Symbol left;
    private final SymbolString right;
    private final int priority;

    public Rule(Symbol left, SymbolString right, int priority) {
        this.left = left;
        this.right = right;
        this.priority = priority;
    }

    public Rule(Symbol left, List<Symbol> right, int priority) {
        this(left, new SymbolString(right), priority);
    }

    public Rule(Symbol left, List<Symbol> right) {
        this(left, right, 0);
    }

    public Symbol getLeft() {
        return this.left;
    }

    public SymbolString getRight() {
        return this.right;
    }

    public static Rule rule(Symbol left, List<Symbol> right, int priority) {
        return new Rule(left, right, priority);
    }

    public static Rule rule(Symbol left, List<Symbol> right) {
        return new Rule(left, right, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.left, rule.left) && Objects.equals(this.right, rule.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return this.left + " -> " + this.right;
    }

    public int getPriority() {
        return this.priority;
    }
}

