/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Bfs {
    public static <T> Set<T> withStream(Stream<T> input, Iteration<T> iteration) {
        Queue queue = input.collect(Collectors.toCollection(LinkedList::new));
        LinkedHashSet visited = new LinkedHashSet(queue);
        while (!queue.isEmpty()) {
            iteration.iterate(queue.poll(), next -> {
                if (visited.add(next)) {
                    queue.add(next);
                }
            });
        }
        return visited;
    }

    public static <T> Set<T> withCollection(Collection<T> input, Iteration<T> iteration) {
        return Bfs.withStream(input.stream(), iteration);
    }

    public static <T> Set<T> withItem(T input, Iteration<T> iteration) {
        return Bfs.withCollection(Collections.singletonList(input), iteration);
    }

    @FunctionalInterface
    public static interface Iteration<T> {
        public void iterate(T var1, Consumer<T> var2);
    }
}

