/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.lr1;

import foundation.rpg.grammar.First;
import foundation.rpg.grammar.Grammar;
import foundation.rpg.grammar.Symbol;
import foundation.rpg.lr1.LrItem;
import foundation.rpg.lr1.LrItemSet;
import foundation.rpg.lr1.LrParserAutomata;
import foundation.rpg.util.Bfs;
import foundation.rpg.util.MapOfSets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LrParserConstructor {
    private final Grammar grammar;
    private final First first;
    private final Map<Symbol, Integer> counters = new LinkedHashMap<Symbol, Integer>();

    public LrParserConstructor(Grammar grammar) {
        this.grammar = grammar.augmented();
        this.first = new First(this.grammar);
    }

    public LrParserAutomata constructAutomata() {
        LrItemSet start = this.closure(Symbol.any, this.grammar.rulesFor(this.grammar.getStart()).stream().map(rule -> LrItem.lrItem(rule, Collections.emptySet())).collect(Collectors.toSet()));
        LrParserAutomata parser = new LrParserAutomata(start, this.grammar);
        parser.addState(start);
        Bfs.withItem(start, (set, queue) -> LrParserConstructor.transitions(parser, set).forEach((transitionSymbol, baseSet) -> {
            LrItemSet nextSet = this.closure((Symbol)transitionSymbol, (Set<LrItem>)baseSet);
            parser.addState(nextSet);
            queue.accept(nextSet);
            parser.transition((LrItemSet)set, (Symbol)transitionSymbol, nextSet);
        }));
        return parser;
    }

    public static MapOfSets<Symbol, LrItem> transitions(LrParserAutomata parser, LrItemSet set) {
        MapOfSets<Symbol, LrItem> transitions = new MapOfSets<Symbol, LrItem>();
        set.getItems().forEach(lrItem -> {
            if (lrItem.isEnd()) {
                if (lrItem.getLookahead().isEmpty()) {
                    parser.accept(set, (LrItem)lrItem);
                } else {
                    lrItem.getLookahead().forEach(lookahead -> parser.reduction(set, (Symbol)lookahead, (LrItem)lrItem));
                }
            } else {
                transitions.add(lrItem.symbolAtDot(), lrItem.moveDot());
            }
        });
        return transitions;
    }

    public LrItemSet closure(Symbol symbol, Set<LrItem> base) {
        Set<LrItem> closure = Bfs.withCollection(base, (item, queue) -> {
            if (!item.isEnd()) {
                this.grammar.rulesFor(item.symbolAtDot()).stream().map(rule -> LrItem.lrItem(rule, this.first.follow(item.afterDot(), item.getLookahead()))).forEach(queue);
            }
        });
        LinkedHashMap aggregator = new LinkedHashMap();
        closure.forEach(i -> aggregator.computeIfAbsent(i.getDot(), d -> new LinkedHashMap()).compute(i.getRule(), (r, t) -> {
            if (Objects.isNull(t)) {
                return i;
            }
            return i.mergeLookahead((LrItem)t);
        }));
        return new LrItemSet("" + symbol + this.counters.compute(symbol, (s, i) -> Objects.isNull(i) ? 1 : i + 1), aggregator.entrySet().stream().flatMap(e -> ((Map)e.getValue()).values().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public static LrParserAutomata generateParser(Grammar grammar) {
        return new LrParserConstructor(grammar).constructAutomata();
    }
}

