/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.gnfa;

import foundation.rpg.util.MapOfSets;
import java.util.Collections;
import java.util.Set;

public final class State {
    public static final State ERROR = new State();
    private final String name;
    private final MapOfSets<Character, State> transitions = new MapOfSets();
    private final MapOfSets<Character, State> groups = new MapOfSets();
    private final State defaultState;

    private State(String name, State defaultState) {
        this.name = name;
        this.defaultState = defaultState;
    }

    private State() {
        this.defaultState = this;
        this.name = "ERROR";
    }

    public static State state(String name) {
        return new State(name, ERROR);
    }

    public static State state(String name, State defaultState) {
        return new State(name, defaultState);
    }

    public void add(Character character, State next) {
        this.transitions.add(character, next);
    }

    public void addGroup(Character character, State next) {
        this.groups.add(character, next);
    }

    public MapOfSets<Character, State> getTransitions() {
        return this.transitions;
    }

    public MapOfSets<Character, State> getGroups() {
        return this.groups;
    }

    public State getDefaultState() {
        return this.defaultState;
    }

    public Set<State> get(Character character) {
        return this.transitions.getOrDefault(character, Collections.singleton(this.defaultState));
    }

    public Set<State> getGroup(Character character) {
        return this.groups.getOrDefault(character, Collections.singleton(this.defaultState));
    }

    public String toString() {
        return super.toString() + "/" + this.name;
    }
}

