/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Rule;
import foundation.rpg.grammar.Symbol;
import foundation.rpg.util.MapOfSets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Grammar {
    private final Symbol start;
    private final Set<Symbol> terminals;
    private final Set<Symbol> nonTerminals;
    private final Set<Rule> rules;
    private final Set<Symbol> ignored;
    private final MapOfSets<Symbol, Rule> rulesBySymbol = new MapOfSets();

    public Grammar(Symbol start, Set<Symbol> terminals, Set<Symbol> nonTerminals, Set<Rule> rules, Set<Symbol> ignored) {
        this.start = start;
        this.terminals = terminals;
        this.nonTerminals = nonTerminals;
        this.rules = rules;
        this.ignored = ignored;
        rules.forEach(rule -> this.rulesBySymbol.add(rule.getLeft(), (Rule)rule));
    }

    public static Grammar grammar(Symbol start, Set<Rule> rules, Set<Symbol> ignored) {
        Set nonTerminals = rules.stream().map(Rule::getLeft).collect(Collectors.toCollection(LinkedHashSet::new));
        Set terminals = rules.stream().flatMap(rule -> rule.getRight().stream()).filter(symbol -> !nonTerminals.contains(symbol)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new Grammar(start, terminals, nonTerminals, rules, ignored);
    }

    public Grammar augmented() {
        LinkedHashSet<Rule> augmentedRules = new LinkedHashSet<Rule>();
        augmentedRules.add(Rule.rule(Symbol.start, Arrays.asList(this.start, Symbol.end)));
        augmentedRules.addAll(this.rules);
        return Grammar.grammar(Symbol.start, augmentedRules, this.ignored);
    }

    public Symbol getStart() {
        return this.start;
    }

    public Set<Symbol> getTerminals() {
        return this.terminals;
    }

    public Set<Symbol> getNonTerminals() {
        return this.nonTerminals;
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public Set<Rule> rulesFor(Symbol symbol) {
        return this.rulesBySymbol.get(symbol);
    }

    public String toString() {
        return "N = " + this.nonTerminals + "\nT = " + this.terminals + "\nS = " + this.start + "\nR = {\n\t" + this.rules.stream().map(Objects::toString).collect(Collectors.joining("\n\t")) + "\n}";
    }

    public Set<Symbol> getIgnored() {
        return this.ignored;
    }
}

