/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.grammar;

import foundation.rpg.grammar.Grammar;
import foundation.rpg.grammar.Rule;
import foundation.rpg.grammar.Symbol;
import foundation.rpg.grammar.SymbolString;
import foundation.rpg.util.MapOfSets;
import java.util.LinkedHashSet;
import java.util.Set;

public final class First {
    private final MapOfSets<Symbol, Symbol> first = new MapOfSets();

    public First(Grammar grammar) {
        grammar.getTerminals().forEach(symbol -> this.first.add((Symbol)symbol, (Symbol)symbol));
        while (this.addedFirstSymbol(grammar)) {
        }
    }

    public Set<Symbol> first(Symbol symbol) {
        return this.first.get(symbol);
    }

    private boolean addedFirstSymbol(Grammar grammar) {
        for (Symbol symbol : grammar.getNonTerminals()) {
            for (Rule rule : grammar.rulesFor(symbol)) {
                if (!this.first.add(symbol, this.addedEpsilon(rule))) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Symbol> addedEpsilon(Rule rule) {
        LinkedHashSet<Symbol> symbols = new LinkedHashSet<Symbol>();
        for (Symbol s : rule.getRight()) {
            symbols.addAll(this.first(s));
            if (!symbols.contains(Symbol.\u03b5)) {
                return symbols;
            }
            symbols.remove(Symbol.\u03b5);
        }
        symbols.add(Symbol.\u03b5);
        return symbols;
    }

    public Set<Symbol> follow(SymbolString string, Set<Symbol> lookahead) {
        LinkedHashSet<Symbol> follow = new LinkedHashSet<Symbol>();
        for (Symbol symbol : string) {
            follow.addAll(this.first(symbol));
            if (!follow.contains(Symbol.\u03b5)) {
                return follow;
            }
            follow.remove(Symbol.\u03b5);
        }
        follow.addAll(lookahead);
        return follow;
    }
}

