/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public final class MapOfSets<K, V> {
    private final Map<K, Set<V>> map = new LinkedHashMap<K, Set<V>>();

    public Set<V> get(K key) {
        return this.getOrDefault(key, Collections.emptySet());
    }

    public Set<V> getOrDefault(K key, Set<V> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public boolean add(K key, V value) {
        return this.map.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }

    public boolean add(K key, Collection<V> value) {
        return this.map.computeIfAbsent(key, k -> new LinkedHashSet()).addAll(value);
    }

    public void forEach(BiConsumer<? super K, ? super Set<V>> consumer) {
        this.map.forEach(consumer);
    }
}

